/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.entity.TaskInstanceDTO;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContext;
import com.tandbergtv.workflow.driver.internal.TaskInstanceFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class TaskInstanceConvertor {
    private static final Logger logger = Logger.getLogger(TaskInstanceConvertor.class);
    private TaskInstanceFilter taskInstanceFilter = new TaskInstanceFilter();

    public TaskInstanceDTO toTaskInstanceDto(TaskInstance instance) {
        if (instance == null) {
            return null;
        }
        Assert.isTrue((instance.getId() > 0L ? 1 : 0) != 0, (String)"No Id assigned for current TaskInstance");
        TaskInstanceDTO instanceDto = new TaskInstanceDTO();
        instanceDto.setTaskId(instance.getId());
        instanceDto.setTokenId(instance.getToken().getId());
        instanceDto.setCurrentNodeName(instance.getTask().getName());
        instanceDto.setStartTime(instance.getStart());
        instanceDto.setEndTime(instance.getEnd());
        return instanceDto;
    }

    public TaskInstance findNewManualTaskInstance(WorkflowProcess process) {
        return this.taskInstanceFilter.findNewManualTaskInstance(process);
    }

    public List<TaskInstance> findManualTaskInstances(CustomToken token) {
        return this.taskInstanceFilter.findManualTaskInstances(token);
    }

    public List<TaskInstanceDTO> toManualTaskInstancesDTO(CustomToken token) {
        List<TaskInstance> instances = this.taskInstanceFilter.findManualTaskInstances(token);
        ArrayList dtos = Lists.newArrayList();
        for (TaskInstance taskInstance : instances) {
            dtos.add(this.toTaskInstanceDto(taskInstance));
        }
        return dtos;
    }

    private void rebuildManualTask(CustomToken token, TaskInstanceDTO manualInstanceDto) {
        if (manualInstanceDto == null) {
            logger.debug((Object)("The Manual Task Instance for Token: " + token.toString() + " may has ended."));
            return;
        }
        WorkflowProcess process = token.getProcessInstance();
        String taskName = manualInstanceDto.getCurrentNodeName();
        logger.debug((Object)("Rebuild manual task instance from dto object, task name: (" + taskName + ") Token: " + token.toString()));
        Task task = process.getProcessDefinition().getTaskMgmtDefinition().getTask(taskName);
        ExecutionContext executionContext = new ExecutionContext((Token)token);
        executionContext.setTask(task);
        TaskMgmtInstance tmi = process.getTaskMgmtInstance();
        TaskInstance manualInstance = tmi.createTaskInstance(task, (org.jbpm.graph.exe.ExecutionContext)executionContext);
        manualInstance.setId(manualInstanceDto.getTaskId());
        manualInstance.setEnd(manualInstanceDto.getEndTime());
    }

    public void rebuildManualTasks(CustomToken customToken, List<TaskInstanceDTO> taskInstances) {
        if (CollectionUtils.isEmpty(taskInstances)) {
            logger.debug((Object)("No Manual Task Instances for Token: " + customToken.toString()));
            return;
        }
        for (TaskInstanceDTO manualInstanceDto : taskInstances) {
            this.rebuildManualTask(customToken, manualInstanceDto);
        }
    }
}

