/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.monitor.IMetricUnit;
import com.tandbergtv.workflow.driver.internal.monitor.MetricLogger;
import java.util.Set;
import org.apache.log4j.Logger;

public class ScheduledMetricLogWriter
implements Service {
    private static final Logger LOGGER = Logger.getLogger(ScheduledMetricLogWriter.class);
    private Scheduler<Void> schedule = new Scheduler("workflow-metrics-log-per-minute-writer", 1, 1);
    private MetricLogger logWriter = new MetricLogger(null);
    private Set<IMetricUnit> metrics = Sets.newLinkedHashSet();
    private Set<IMetricUnit> oddRunMetrics = Sets.newLinkedHashSet();
    private volatile boolean isOddRun = true;
    private int interval = 30000;
    private static ScheduledMetricLogWriter instance = new ScheduledMetricLogWriter();

    protected ScheduledMetricLogWriter() {
    }

    public static ScheduledMetricLogWriter getInstance() {
        return instance;
    }

    public void addMetricUnit(IMetricUnit unit) {
        LOGGER.debug((Object)("add a MetricUnit to logger : " + unit.getMetricName() + "," + unit.getClass()));
        this.metrics.add(unit);
    }

    public void addMetricUnit(IMetricUnit unit, Boolean outputOnlyPerMinute) {
        LOGGER.debug((Object)("add a MetricUnit to logger : " + unit.getMetricName() + "," + unit.getClass()));
        this.metrics.add(unit);
        this.oddRunMetrics.add(unit);
    }

    public void start() {
        LOGGER.debug((Object)"Starting Metric Logger Writer service");
        try {
            this.schedule.schedule(() -> this.writeLogs(), 30000L, (long)this.interval);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("The MetricLogWriter may have some issues:" + e));
        }
        LOGGER.debug((Object)"Metric Logger Writer service Started");
    }

    void writeLogs() {
        for (IMetricUnit iMetricUnit : this.metrics) {
            LOGGER.debug((Object)("Start to write the metrics log  for " + iMetricUnit.getMetricName()));
            this.logWriter.setMetricName(iMetricUnit.getMetricName());
            if (iMetricUnit.onlyWriteInMasterNode() && !this.isMasterNode() || this.oddRunMetrics.contains(iMetricUnit) && !this.isOddRun) continue;
            iMetricUnit.write(this.logWriter);
        }
        this.isOddRun = !this.isOddRun;
    }

    public void stop() {
        this.writeLogs();
        this.schedule.stop();
        LOGGER.debug((Object)"stopped");
    }

    public void setInterval(int intervalInMs) {
        this.interval = intervalInMs;
    }

    private boolean isMasterNode() {
        return ServiceLookup.findClusterService() != null && ServiceLookup.findClusterService().isMaster();
    }

    public String getServiceName() {
        return "ScheduledMetricLogWriter";
    }
}

