/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.process;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.process.IProcessLocalCacheSyncPolicy;
import java.util.Map;
import org.apache.log4j.Logger;

public class SimpleVariablePrioritySyncPolicy
implements IProcessLocalCacheSyncPolicy {
    private static final Logger LOGGER = Logger.getLogger(SimpleVariablePrioritySyncPolicy.class);

    @Override
    public void sync(WorkflowProcess source, WorkflowProcess target) {
        this.syncPriority(source, target);
        this.syncVariables(source, target);
        this.syncStatus(source, target);
        this.syncSubProcesses(source, target);
    }

    private void syncStatus(WorkflowProcess source, WorkflowProcess target) {
        CustomToken l2RootToken = source.getRootToken();
        CustomToken l1RootToken = target.getRootToken();
        if (l2RootToken.getStatus() != l1RootToken.getStatus()) {
            l1RootToken.setStatus(l2RootToken.getStatus());
        }
        if (l2RootToken.getRequestedStatus() != l1RootToken.getRequestedStatus()) {
            l1RootToken.setRequestedStatus(l2RootToken.getRequestedStatus());
        }
    }

    private void syncSubProcesses(WorkflowProcess source, WorkflowProcess target) {
    }

    private void syncVariables(WorkflowProcess source, WorkflowProcess target) {
        Map sourceVariables;
        Map targetVariables = target.getContextInstance().getVariables();
        if (targetVariables != null) {
            targetVariables.clear();
        }
        if ((sourceVariables = source.getContextInstance().getVariables()) != null) {
            for (Object key : sourceVariables.keySet()) {
                Object variable = sourceVariables.get(key);
                LOGGER.debug((Object)("copy " + key + ": " + variable + " to L1 cache Object"));
                target.getContextInstance().setVariable((String)key, variable);
            }
        }
    }

    private void syncPriority(WorkflowProcess source, WorkflowProcess target) {
        if (source.getPriority() != target.getPriority()) {
            target.setPriority(source.getPriority());
        }
    }
}

