/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.internal.ConfFolder;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.message.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.variableinstance.DateInstance;
import org.jbpm.context.exe.variableinstance.StringInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.Token;
import org.joda.time.format.DateTimeFormat;
import org.springframework.util.Assert;

public class WfsEsProcessHelper {
    private static final String LICENSING_WINDOW_START = "licensingWindowStart";
    private static final String INGEST_TEMPLATE = "ingestTemplate";
    private static final String PROVIDER_ID = "provider_id";
    private static final String PROVIDERID = "providerId";
    private static final String LICENSING_WINDOW_END = "licensingWindowEnd";
    private static final String LICENSE_END = "license_end";
    private static final String LICENSEEND = "licenseEnd";
    private static final String LICENSE_START = "license_start";
    private static final String LICENSESTART = "licenseStart";
    private static final String TITLE_BRIEF = "title_brief";
    private static final String TITLEBRIEF = "titleBrief";
    private static final String TITLE_ID = "title_id";
    private static final String TITLEID = "titleId";
    private static final String LAST_ALLOCATED_RESOURCE_VARIABLE = "_last_allocated_resource";
    private static final Logger LOGGER = Logger.getLogger(WfsEsProcessHelper.class);
    private static WfsEsProcessHelper instance = new WfsEsProcessHelper();
    private static final String DEFAULT_MAPPING_FILE = "com/tandbergtv/workflow/driver/search/elasticsearch/wfs_index.json";
    private static final String CUSTOM_MAPPING_FILE = "custom_wfs_mappings.json";
    private int connectionTimeout = 3000;
    private List<String> defaultMappingFields = new ArrayList<String>();
    private List<String> customMappingFields = new ArrayList<String>();

    private WfsEsProcessHelper() {
        this.initializeMappingFields();
    }

    public static WfsEsProcessHelper getInstance() {
        return instance;
    }

    public XContentBuilder createProcess(WorkflowProcess process) throws IOException {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            throw new IllegalArgumentException("Process appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.addSearchFields(builder, process);
        builder.endObject();
        return builder;
    }

    public XContentBuilder createGUIParitalUpdateBuilder(WorkflowProcess process) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        this.addSearchableField(builder, "priority", process.getPriority());
        this.addSearchableField(builder, "note", process.getFormatedNotes());
        builder.endObject();
        return builder;
    }

    public XContentBuilder createBuilder(WFSearchResult wfsResult) throws IOException {
        if (wfsResult == null || wfsResult.getProcessId() < 1L || wfsResult.getToken().getTokenId() < 1L) {
            throw new IllegalArgumentException("WFSearchResult appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.addSearchFields(builder, wfsResult);
        builder.endObject();
        return builder;
    }

    public boolean trySaving(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "_doc", id);
            bld.setSource(source);
            bld.execute().actionGet((long)this.connectionTimeout);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean savingNoWait(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "_doc", id);
            bld.setSource(source);
            bld.execute();
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean tryDeleting(String id, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            DeleteRequestBuilder bld = client.prepareDelete("wfs", "_doc", id);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not delete process " + id), (Throwable)e);
            return false;
        }
    }

    private void addSearchFields(XContentBuilder bldr, WFSearchResult wfsResult) {
        Map variables = wfsResult.getVariables();
        this.addSearchableField(bldr, "id", wfsResult.getProcessId());
        if (variables.get("templateId") != null) {
            this.addSearchableField(bldr, "templateId", Long.valueOf(((WFVariable)variables.get("templateId")).getValue()));
        }
        this.addSearchableField(bldr, "templateName", wfsResult.getProcessDefinitionName());
        this.addSearchableField(bldr, "adminStatus", ProcessStatus.values()[wfsResult.getToken().getAdministrativeStatus()]);
        this.addSearchableField(bldr, "status", ProcessStatus.values()[wfsResult.getToken().getOperationalStatus()]);
        this.addSearchableField(bldr, "priority", ProcessPriority.values()[wfsResult.getPriority()]);
        this.addSearchableField(bldr, "createId", wfsResult.getCreateId().toString());
        if (this.isNotEmpty(variables, PROVIDER_ID)) {
            this.addSearchableField(bldr, PROVIDER_ID, ((WFVariable)variables.get(PROVIDER_ID)).getValue());
        }
        if (this.isNotEmpty(variables, TITLE_ID)) {
            this.addSearchableField(bldr, TITLE_ID, Long.valueOf(((WFVariable)variables.get(TITLE_ID)).getValue()));
        }
        this.addSearchableField(bldr, "isActive", Boolean.valueOf(wfsResult.getIsActive()));
        this.addSearchableField(bldr, "currentTask", wfsResult.getToken().getNodeName());
        this.addSearchableField(bldr, "startTime", wfsResult.getToken().getStartTime());
        this.addSearchableField(bldr, "endTime", wfsResult.getToken().getEndTime());
        this.addSearchableField(bldr, "superProcessTokenId", wfsResult.getSuperProcessTokenId());
        this.addSearchableField(bldr, "hasChildren", wfsResult.getToken().getAllChildren().size() > 0);
        this.addSearchableField(bldr, "hasFailedBranch", wfsResult.isHasFailedBranch());
        this.addSearchableField(bldr, "rootTokenId", wfsResult.getToken().getTokenId());
        if (wfsResult.getToken().getErrorTime() != null) {
            this.addSearchableField(bldr, "errorTime", wfsResult.getToken().getErrorTime());
        }
        if (wfsResult.getToken().getErrorComment() != null && !wfsResult.getToken().getErrorComment().isEmpty()) {
            this.addSearchableField(bldr, "errorComment", wfsResult.getToken().getErrorComment());
        }
        if (wfsResult.getToken().getErrorType() > 0) {
            this.addSearchableField(bldr, "errorType", ErrorCategory.values()[wfsResult.getToken().getErrorType()]);
        }
        this.addSearchableField(bldr, "parentProcessId", wfsResult.getParentProcessId());
        this.addSearchableField(bldr, LAST_ALLOCATED_RESOURCE_VARIABLE, variables.get(LAST_ALLOCATED_RESOURCE_VARIABLE));
        for (String field : this.customMappingFields) {
            if (variables.get(field) == null) continue;
            this.addSearchableField(bldr, field, variables.get(field));
        }
    }

    private boolean isNotEmpty(Map<String, WFVariable> variables, String key) {
        return variables.get(key) != null && !variables.get(key).getValue().isEmpty();
    }

    private void addSearchFields(XContentBuilder bldr, WorkflowProcess proc) {
        CustomToken token;
        this.addSearchableField(bldr, "id", proc.getId());
        this.addSearchableField(bldr, "templateId", proc.getProcessDefinition().getId());
        this.addSearchableField(bldr, "templateName", proc.getProcessDefinition().getFullName());
        this.addSearchableField(bldr, "adminStatus", proc.getRootToken().getRequestedStatus());
        this.addSearchableField(bldr, "status", proc.getRootToken().getStatus());
        this.addSearchableField(bldr, "priority", proc.getPriority());
        this.addSearchableField(bldr, "note", proc.getFormatedNotes());
        this.addSearchableField(bldr, "createId", proc.getCreateId());
        TokenVariableMap tMap = proc.getContextInstance().getTokenVariableMap((Token)proc.getRootToken());
        HashSet tMapLocal = new HashSet();
        try {
            tMapLocal.addAll(tMap.getVariables().keySet());
        }
        catch (ConcurrentModificationException e) {
            LOGGER.debug((Object)(proc + " Error while saving variables for process, retrying..."), (Throwable)e);
            try {
                tMapLocal.addAll(tMap.getVariables().keySet());
            }
            catch (ConcurrentModificationException e1) {
                LOGGER.warn((Object)(proc + " Failed to save variables."), (Throwable)e1);
            }
        }
        for (String varName : tMapLocal) {
            Date dtVal;
            if (TITLEID.equalsIgnoreCase(varName) || TITLE_ID.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, TITLE_ID, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (TITLEBRIEF.equalsIgnoreCase(varName) || TITLE_BRIEF.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, TITLE_BRIEF, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (LICENSESTART.equalsIgnoreCase(varName) || LICENSE_START.equalsIgnoreCase(varName) || LICENSING_WINDOW_START.equalsIgnoreCase(varName)) {
                dtVal = null;
                if (tMap.getVariableInstance(varName) instanceof DateInstance) {
                    dtVal = (Date)tMap.getVariableInstance(varName).getValue();
                } else if (tMap.getVariableInstance(varName) instanceof StringInstance) {
                    dtVal = this.convertTitleStringToDate((String)tMap.getVariableInstance(varName).getValue());
                }
                if (dtVal == null) continue;
                this.addSearchableField(bldr, LICENSE_START, dtVal);
                continue;
            }
            if (LICENSEEND.equalsIgnoreCase(varName) || LICENSE_END.equalsIgnoreCase(varName) || LICENSING_WINDOW_END.equalsIgnoreCase(varName)) {
                dtVal = null;
                if (tMap.getVariableInstance(varName) instanceof DateInstance) {
                    dtVal = (Date)tMap.getVariableInstance(varName).getValue();
                } else if (tMap.getVariableInstance(varName) instanceof StringInstance) {
                    dtVal = this.convertTitleStringToDate((String)tMap.getVariableInstance(varName).getValue());
                }
                if (dtVal == null) continue;
                this.addSearchableField(bldr, LICENSE_END, dtVal);
                continue;
            }
            if (PROVIDERID.equalsIgnoreCase(varName) || PROVIDER_ID.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, PROVIDER_ID, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (INGEST_TEMPLATE.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, INGEST_TEMPLATE, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (LAST_ALLOCATED_RESOURCE_VARIABLE.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, LAST_ALLOCATED_RESOURCE_VARIABLE, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (!this.customMappingFields.contains(varName)) continue;
            this.addSearchableField(bldr, varName, tMap.getVariableInstance(varName).getValue());
        }
        this.addSearchableField(bldr, "isActive", proc.isActive());
        this.addSearchableField(bldr, "currentTask", proc.getRootToken().getCurrentNode().getName());
        if (proc.getStart() != null) {
            this.addSearchableField(bldr, "startTime", proc.getStart());
        }
        if (proc.getEnd() != null) {
            this.addSearchableField(bldr, "endTime", proc.getEnd());
        }
        if (proc.getSuperProcessToken() != null) {
            this.addSearchableField(bldr, "superProcessTokenId", proc.getSuperProcessToken().getId());
        } else {
            this.addSearchableField(bldr, "superProcessTokenId", null);
        }
        if (proc.getRootToken().getChildren() != null && proc.getRootToken().getChildren().size() > 0) {
            this.addSearchableField(bldr, "hasChildren", true);
            boolean failed = false;
            for (CustomToken token2 : proc.findAllTokens()) {
                if (token2.isRoot() || token2.getStatus() != ProcessStatus.ERROR || proc.getRootToken().getStatus() != ProcessStatus.BRANCHED) continue;
                failed = true;
            }
            this.addSearchableField(bldr, "hasFailedBranch", failed);
        } else {
            this.addSearchableField(bldr, "hasChildren", false);
            this.addSearchableField(bldr, "hasFailedBranch", false);
        }
        this.addSearchableField(bldr, "rootTokenId", proc.getRootToken().getId());
        if (proc.getRootToken().getErrorDetails() != null) {
            this.addSearchableField(bldr, "errorTime", proc.getRootToken().getErrorDetails().getTime());
            this.addSearchableField(bldr, "errorComment", proc.getRootToken().getErrorDetails().getMessage());
            this.addSearchableField(bldr, "errorType", proc.getRootToken().getErrorDetails().getCategory());
        }
        this.addSearchableField(bldr, "parentProcessId", (token = proc.getSuperProcessToken()) == null ? 0L : token.getProcessInstance().getId());
    }

    private Date convertTitleStringToDate(String date) {
        Date retVal = null;
        if (date != null && !date.isEmpty()) {
            try {
                retVal = WfsEsParameters.getUTCFormat(date, TimeZone.getTimeZone("UTC")).parse(date);
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Date received from Title Service [" + date + "] is not in correct format. Expected format :" + "yyyy-MM-dd"), (Throwable)e);
            }
        }
        return retVal;
    }

    private void addSearchableField(XContentBuilder bldr, String key, Object value) {
        try {
            bldr.field(key, value);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Cannot add field", (Throwable)ex);
        }
    }

    private void addSearchableField(XContentBuilder bldr, String key, Date value) {
        try {
            bldr.field(key, value, DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Cannot add a date field: " + key + " for" + value), (Throwable)ex);
        }
    }

    public void addResultProperties(SearchRequestBuilder bld) {
        ArrayList all = Lists.newArrayList();
        all.addAll(this.defaultMappingFields);
        all.addAll(this.customMappingFields);
        bld.setFetchSource(all.toArray(new String[0]), null);
    }

    private Object fetchValue(SearchHit hit, String fieldName) {
        return hit.getSourceAsMap().get(fieldName);
    }

    public long getLongField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return Configuration.toLong((Object)value, (long)0L);
    }

    public String getStringField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return value == null ? "" : value.toString();
    }

    public int getStatusField(SearchHit hit, String fieldName) {
        String value = this.getStringField(hit, fieldName);
        return StringUtils.isBlank((String)value) ? -1 : ProcessStatus.valueOf((String)value).ordinal();
    }

    public int getIntField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return Configuration.toInteger((Object)value, (int)0);
    }

    public Date getDateField(SearchHit hit, String fieldName) throws ParseException {
        Object value = this.fetchValue(hit, fieldName);
        return value == null ? null : WfsEsParameters.getUTCFormat(value.toString(), TimeZone.getTimeZone("UTC")).parse(value.toString());
    }

    public boolean getBooleanField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return Configuration.toBoolean((Object)value, (boolean)false);
    }

    public WFSearchResult convert(SearchHit hit, long totalCount) {
        String superProcessToken;
        String creatId;
        String note;
        Assert.notNull((Object)hit, (String)"SearchHit is null");
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(this.getLongField(hit, "id"));
        if (!this.getStringField(hit, "priority").isEmpty()) {
            String priority = this.getStringField(hit, "priority");
            switch (priority.toUpperCase()) {
                case "LOWEST": {
                    result.setPriority(0);
                    break;
                }
                case "LOW": {
                    result.setPriority(5);
                    break;
                }
                case "NORMAL": {
                    result.setPriority(10);
                    break;
                }
                case "HIGH": {
                    result.setPriority(15);
                    break;
                }
                case "HIGHEST": {
                    result.setPriority(19);
                    break;
                }
                default: {
                    ProcessPriority prioryType = ProcessPriority.valueOf((String)priority);
                    if (prioryType == null) break;
                    result.setPriority(prioryType.ordinal());
                }
            }
        }
        if (!(note = this.getStringField(hit, "note")).isEmpty()) {
            result.setNote(note);
        }
        if (!(creatId = this.getStringField(hit, "createId")).isEmpty()) {
            result.setCreateId(creatId);
        }
        if (!(superProcessToken = this.getStringField(hit, "superProcessTokenId")).isEmpty()) {
            result.setSuperProcessTokenId(this.getLongField(hit, "superProcessTokenId"));
        }
        boolean hasFailedBranch = this.getBooleanField(hit, "hasFailedBranch");
        result.setHasFailedBranch(hasFailedBranch);
        WFToken rootToken = new WFToken();
        rootToken.setTokenId(this.getLongField(hit, "rootTokenId"));
        rootToken.setProcessId(result.getProcessId());
        rootToken.setAdministrativeStatus(this.getStatusField(hit, "adminStatus"));
        rootToken.setOperationalStatus(this.getStatusField(hit, "status"));
        rootToken.setNodeName(this.getStringField(hit, "currentTask"));
        try {
            rootToken.setStartTime(this.getDateField(hit, "startTime"));
            rootToken.setEndTime(this.getDateField(hit, "endTime"));
            rootToken.setErrorTime(this.getDateField(hit, "errorTime"));
            rootToken.setErrorComment(this.getStringField(hit, "errorComment"));
            if (!this.getStringField(hit, "errorType").isEmpty()) {
                rootToken.setErrorType(ErrorCategory.valueOf((String)this.getStringField(hit, "errorType")).ordinal());
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unknown error to update token status", (Throwable)e);
        }
        result.setToken(rootToken);
        WFVariable titleId = new WFVariable();
        titleId.setName(TITLE_ID);
        titleId.addValue(this.getStringField(hit, TITLE_ID));
        result.addVariable(titleId);
        WFVariable titleBrief = new WFVariable();
        titleBrief.setName(TITLE_BRIEF);
        titleBrief.addValue(this.getStringField(hit, TITLE_BRIEF));
        result.addVariable(titleBrief);
        String selectorKey = this.getStringField(hit, INGEST_TEMPLATE);
        if (selectorKey != null && !selectorKey.isEmpty()) {
            WFVariable ingestTemplate = new WFVariable();
            ingestTemplate.setName(INGEST_TEMPLATE);
            ingestTemplate.addValue(selectorKey);
            result.addVariable(ingestTemplate);
        }
        WFVariable isActive = new WFVariable();
        isActive.setName("isActive");
        String isActiveStr = this.getStringField(hit, "isActive");
        isActive.addValue(isActiveStr);
        result.addVariable(isActive);
        result.setIsActive(isActiveStr);
        WFVariable templateId = new WFVariable();
        templateId.setName("templateId");
        templateId.addValue(this.getStringField(hit, "templateId"));
        result.addVariable(templateId);
        try {
            Date licenseStartDate = this.getDateField(hit, LICENSE_START);
            if (licenseStartDate != null) {
                String licenseStartStr = this.getFormatedDateField(hit, LICENSE_START);
                WFVariable licenseStart = new WFVariable();
                licenseStart.setName(LICENSE_START);
                licenseStart.addValue(licenseStartStr);
                result.addVariable(licenseStart);
                WFVariable licenseStart1 = new WFVariable();
                licenseStart1.setName(LICENSING_WINDOW_START);
                licenseStart1.addValue(licenseStartStr);
                result.addVariable(licenseStart1);
                WFVariable licenseStart2 = new WFVariable();
                licenseStart2.setName(LICENSE_START);
                licenseStart2.addValue(licenseStartStr);
                result.addVariable(licenseStart2);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not parse license start date", (Throwable)e);
        }
        try {
            Date licenseEndDate = this.getDateField(hit, LICENSE_END);
            if (licenseEndDate != null) {
                String licenseEndStr = this.getFormatedDate(licenseEndDate);
                WFVariable licenseEnd = new WFVariable();
                licenseEnd.setName(LICENSE_END);
                licenseEnd.addValue(licenseEndStr);
                result.addVariable(licenseEnd);
                WFVariable licenseEnd1 = new WFVariable();
                licenseEnd1.setName(LICENSING_WINDOW_END);
                licenseEnd1.addValue(licenseEndStr);
                result.addVariable(licenseEnd1);
                WFVariable licenseEnd2 = new WFVariable();
                licenseEnd2.setName(LICENSE_END);
                licenseEnd2.addValue(licenseEndStr);
                result.addVariable(licenseEnd2);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not parse license end date", (Throwable)e);
        }
        WFVariable providerId = new WFVariable();
        providerId.setName(PROVIDER_ID);
        providerId.addValue(this.getStringField(hit, PROVIDER_ID));
        result.addVariable(providerId);
        if (this.getBooleanField(hit, "hasChildren")) {
            result.addChild(new WFSearchResult());
            while (result.getToken().getAllChildren().size() <= 1) {
                result.getToken().addChild(new WFToken());
            }
        }
        result.setProcessDefinitionName(this.getStringField(hit, "templateName"));
        WFVariable lastAllocatedResource = new WFVariable();
        lastAllocatedResource.setName(LAST_ALLOCATED_RESOURCE_VARIABLE);
        lastAllocatedResource.addValue(this.getStringField(hit, LAST_ALLOCATED_RESOURCE_VARIABLE));
        result.addVariable(lastAllocatedResource);
        for (String field : this.customMappingFields) {
            WFVariable variable = new WFVariable();
            variable.setName(field);
            variable.addValue(this.getStringField(hit, field));
            result.addVariable(variable);
        }
        result.setSearchResultCount(totalCount);
        this.setNodeName(result.getProcessDefinitionName(), result.getToken());
        result.setParentProcessId(this.getLongField(hit, "parentProcessId"));
        return result;
    }

    private String getFormatedDateField(SearchHit hit, String key) throws ParseException {
        return this.getFormatedDate(this.getDateField(hit, key));
    }

    private String getFormatedDate(Date date) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(date);
    }

    private void setNodeName(String templateName, final WFToken token) {
        ITemplateService templateService = (ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
        WorkflowTemplate template = templateService.getTemplateByFullName(templateName);
        if (template == null) {
            return;
        }
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                Node currentNode;
                if (node instanceof SuperState && (currentNode = ((SuperState)node).getNode(token.getNodeName())) != null) {
                    token.setNodeName(node.getName());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMappingFields() {
        InputStream defaultMappingInputStream = null;
        try {
            defaultMappingInputStream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_MAPPING_FILE);
            this.addMappingFields(defaultMappingInputStream, this.defaultMappingFields);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(defaultMappingInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)defaultMappingInputStream);
        FileInputStream customMappingInputStream = null;
        String file = ConfFolder.getWFConfFolder() + "/" + CUSTOM_MAPPING_FILE;
        try {
            customMappingInputStream = new FileInputStream(file);
            this.addMappingFields(customMappingInputStream, this.customMappingFields);
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.debug((Object)(file + " is not found." + e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(customMappingInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)customMappingInputStream);
        }
        IOUtils.closeQuietly((InputStream)customMappingInputStream);
    }

    private void addMappingFields(InputStream is, List<String> mappingFields) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree(is);
            Iterator nodeIterator = root.findPath("properties").fieldNames();
            while (nodeIterator.hasNext()) {
                String field = (String)nodeIterator.next();
                if (!this.defaultMappingFields.contains(field) && !this.customMappingFields.contains(field)) {
                    mappingFields.add(field);
                    LOGGER.debug((Object)("Added fieldName: " + field));
                    continue;
                }
                LOGGER.warn((Object)("The fieldName: " + field + " already exist."));
            }
        }
        catch (JsonProcessingException jpe) {
            LOGGER.error((Object)("Error occurred while processing " + is), (Throwable)jpe);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)("Error occurred reading " + is), (Throwable)ioe);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Singleton class does not allow cloning!");
    }
}

