/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.template.IArchivalStrategy;
import com.tandbergtv.workflow.driver.template.IESDeleteService;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.node.ProcessState;

public class VersionBasedArchivalStrategy
implements IArchivalStrategy {
    private static final Logger LOGGER = Logger.getLogger(VersionBasedArchivalStrategy.class);
    private ITemplateService templateService;
    private IProcessSearchService search;
    private IESDeleteService processDeleter;

    public VersionBasedArchivalStrategy(IESDeleteService processDeleter) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        this.templateService = (ITemplateService)registry.lookup(ITemplateService.class);
        this.search = (IProcessSearchService)registry.lookup(IProcessSearchService.class);
        this.processDeleter = processDeleter;
    }

    @Override
    public void archive() {
        for (WorkflowTemplate template : this.templateService.getLatestTemplates()) {
            this.archive(template);
        }
    }

    @Override
    public void archive(WorkflowTemplate template) {
        LOGGER.info((Object)("Trying to delete older versions of template " + template));
        for (WorkflowTemplate previous : this.templateService.getPreviousVersions(template)) {
            if (this.isSubProcess(previous)) continue;
            SearchCriteria criteria = new SearchCriteria();
            this.template(criteria, previous.getId());
            int count = this.search.expressCount(criteria);
            LOGGER.info((Object)("Found " + count + " process(es) of template " + previous));
            if (count == 0) {
                this.templateService.deactivate(previous.getId());
                continue;
            }
            this.processDeleter.addToCache(previous);
        }
    }

    private SearchCriteria template(SearchCriteria criteria, Long templateId) {
        ListParameter parameter = new ListParameter("templateId", SearchType.NUMERIC);
        parameter.addValue((Object)templateId);
        criteria.addParameter((SearchParameterBase)parameter);
        return criteria;
    }

    private boolean isSubProcess(WorkflowTemplate template) {
        List<WorkflowTemplate> templates = this.templateService.findAllTemplates();
        for (WorkflowTemplate t : templates) {
            if (t.equals((Object)template)) continue;
            for (Node node : t.getNodes()) {
                ProcessState p;
                if (!(node instanceof ProcessState) || !(p = (ProcessState)ProcessState.class.cast(node)).getSubProcessDefinition().equals((Object)template)) continue;
                LOGGER.info((Object)(template + " is used by " + t));
                return true;
            }
        }
        return false;
    }
}

