/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;

public class CompletionSuggester
extends Suggester<CompletionSuggestionContext> {
    public static final CompletionSuggester INSTANCE = new CompletionSuggester();

    private CompletionSuggester() {
    }

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, CompletionSuggestionContext suggestionContext, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        if (suggestionContext.getFieldType() != null) {
            CompletionFieldMapper.CompletionFieldType fieldType = suggestionContext.getFieldType();
            CompletionSuggestion completionSuggestion = new CompletionSuggestion(name, suggestionContext.getSize(), suggestionContext.isSkipDuplicates());
            spare.copyUTF8Bytes(suggestionContext.getText());
            CompletionSuggestion.Entry completionSuggestEntry = new CompletionSuggestion.Entry(new Text(spare.toString()), 0, spare.length());
            completionSuggestion.addTerm(completionSuggestEntry);
            int shardSize = suggestionContext.getShardSize() != null ? suggestionContext.getShardSize().intValue() : suggestionContext.getSize();
            TopDocumentsCollector collector = new TopDocumentsCollector(shardSize, suggestionContext.isSkipDuplicates());
            CompletionSuggester.suggest(searcher, suggestionContext.toQuery(), collector);
            int numResult = 0;
            for (TopSuggestDocs.SuggestScoreDoc suggestScoreDoc : collector.get().scoreLookupDocs()) {
                TopDocumentsCollector.SuggestDoc suggestDoc = (TopDocumentsCollector.SuggestDoc)suggestScoreDoc;
                Map<String, Set<CharSequence>> contexts = Collections.emptyMap();
                if (fieldType.hasContextMappings() && !suggestDoc.getContexts().isEmpty()) {
                    contexts = fieldType.getContextMappings().getNamedContexts(suggestDoc.getContexts());
                }
                if (numResult++ >= suggestionContext.getSize()) break;
                CompletionSuggestion.Entry.Option option = new CompletionSuggestion.Entry.Option(suggestDoc.doc, new Text(suggestDoc.key.toString()), suggestDoc.score, contexts);
                completionSuggestEntry.addOption(option);
            }
            return completionSuggestion;
        }
        return null;
    }

    private static void suggest(IndexSearcher searcher, CompletionQuery query, TopSuggestDocsCollector collector) throws IOException {
        query = (CompletionQuery)query.rewrite(searcher.getIndexReader());
        Weight weight = query.createWeight(searcher, collector.needsScores(), 1.0f);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            BulkScorer scorer = weight.bulkScorer(context);
            if (scorer == null) continue;
            try {
                scorer.score(collector.getLeafCollector(context), context.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }

    private static final class TopDocumentsCollector
    extends TopSuggestDocsCollector {
        private final Map<Integer, SuggestDoc> docsMap;

        TopDocumentsCollector(int num, boolean skipDuplicates) {
            super(Math.max(1, num), skipDuplicates);
            this.docsMap = new LinkedHashMap<Integer, SuggestDoc>(num);
        }

        public void collect(int docID, CharSequence key, CharSequence context, float score) throws IOException {
            int globalDoc = docID + this.docBase;
            if (this.docsMap.containsKey(globalDoc)) {
                this.docsMap.get(globalDoc).add(key, context, score);
            } else {
                this.docsMap.put(globalDoc, new SuggestDoc(globalDoc, key, context, score));
                super.collect(docID, key, context, score);
            }
        }

        public TopSuggestDocs get() throws IOException {
            TopSuggestDocs entries = super.get();
            if (entries.scoreDocs.length == 0) {
                return TopSuggestDocs.EMPTY;
            }
            int size = entries.scoreDocs.length;
            ArrayList<SuggestDoc> suggestDocs = new ArrayList<SuggestDoc>(size);
            CharArraySet seenSurfaceForms = this.doSkipDuplicates() ? new CharArraySet(size, false) : null;
            for (TopSuggestDocs.SuggestScoreDoc suggestEntry : entries.scoreLookupDocs()) {
                SuggestDoc suggestDoc = this.docsMap != null ? this.docsMap.get(suggestEntry.doc) : new SuggestDoc(suggestEntry.doc, suggestEntry.key, suggestEntry.context, suggestEntry.score);
                if (this.doSkipDuplicates()) {
                    if (seenSurfaceForms.contains(suggestDoc.key)) continue;
                    seenSurfaceForms.add(suggestDoc.key);
                }
                suggestDocs.add(suggestDoc);
            }
            return new TopSuggestDocs((int)entries.totalHits, suggestDocs.toArray(new TopSuggestDocs.SuggestScoreDoc[0]), entries.getMaxScore());
        }

        private static final class SuggestDoc
        extends TopSuggestDocs.SuggestScoreDoc {
            private List<TopSuggestDocs.SuggestScoreDoc> suggestScoreDocs;

            SuggestDoc(int doc, CharSequence key, CharSequence context, float score) {
                super(doc, key, context, score);
            }

            void add(CharSequence key, CharSequence context, float score) {
                if (this.suggestScoreDocs == null) {
                    this.suggestScoreDocs = new ArrayList<TopSuggestDocs.SuggestScoreDoc>(1);
                }
                this.suggestScoreDocs.add(new TopSuggestDocs.SuggestScoreDoc(this.doc, key, context, score));
            }

            public List<CharSequence> getKeys() {
                if (this.suggestScoreDocs == null) {
                    return Collections.singletonList(this.key);
                }
                ArrayList<CharSequence> keys = new ArrayList<CharSequence>(this.suggestScoreDocs.size() + 1);
                keys.add(this.key);
                for (TopSuggestDocs.SuggestScoreDoc scoreDoc : this.suggestScoreDocs) {
                    keys.add(scoreDoc.key);
                }
                return keys;
            }

            public List<CharSequence> getContexts() {
                if (this.suggestScoreDocs == null) {
                    if (this.context != null) {
                        return Collections.singletonList(this.context);
                    }
                    return Collections.emptyList();
                }
                ArrayList<CharSequence> contexts = new ArrayList<CharSequence>(this.suggestScoreDocs.size() + 1);
                contexts.add(this.context);
                for (TopSuggestDocs.SuggestScoreDoc scoreDoc : this.suggestScoreDocs) {
                    contexts.add(scoreDoc.context);
                }
                return contexts;
            }
        }
    }
}

