/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.impl.TcpIpJoiner;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import java.util.ArrayList;
import java.util.Collection;

public class DiscoveryJoiner
extends TcpIpJoiner {
    private final DiscoveryService discoveryService;
    private final boolean usePublicAddress;

    public DiscoveryJoiner(Node node, DiscoveryService discoveryService, boolean usePublicAddress) {
        super(node);
        this.discoveryService = discoveryService;
        this.usePublicAddress = usePublicAddress;
    }

    @Override
    protected Collection<Address> getPossibleAddresses() {
        Iterable<DiscoveryNode> discoveredNodes = this.discoveryService.discoverNodes();
        MemberImpl localMember = this.node.nodeEngine.getLocalMember();
        Address localAddress = localMember.getAddress();
        ArrayList<Address> possibleMembers = new ArrayList<Address>();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            Address discoveredAddress;
            Address address = discoveredAddress = this.usePublicAddress ? discoveryNode.getPublicAddress() : discoveryNode.getPrivateAddress();
            if (localAddress.equals(discoveredAddress)) continue;
            possibleMembers.add(discoveredAddress);
        }
        return possibleMembers;
    }
}

