/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.Clock;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ResponseQueueFactory {
    private ResponseQueueFactory() {
    }

    public static BlockingQueue<Object> newResponseQueue() {
        return new LockBasedResponseQueue();
    }

    private static final class LockBasedResponseQueue
    extends AbstractQueue<Object>
    implements BlockingQueue<Object> {
        private static final Object NULL = new Object();
        private final Lock lock = new ReentrantLock();
        private final Condition noValue = this.lock.newCondition();
        private Object response;

        private LockBasedResponseQueue() {
        }

        @Override
        public Object take() throws InterruptedException {
            this.lock.lock();
            try {
                while (this.response == null) {
                    this.noValue.await();
                }
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean offer(Object object, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            this.lock.lock();
            try {
                long start;
                boolean timedOut = false;
                for (long remaining = unit.toMillis(timeout); this.response == null && remaining > 0L && !timedOut; remaining -= Clock.currentTimeMillis() - start) {
                    start = Clock.currentTimeMillis();
                    timedOut = this.noValue.await(remaining, TimeUnit.MILLISECONDS);
                }
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void put(Object object) throws InterruptedException {
            this.offer(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(Object object) {
            Object item = object;
            if (item == null) {
                item = NULL;
            }
            this.lock.lock();
            try {
                if (this.response != null) {
                    boolean bl = false;
                    return bl;
                }
                this.response = item;
                this.noValue.signal();
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Object poll() {
            this.lock.lock();
            try {
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public int remainingCapacity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int drainTo(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int drainTo(Collection c, int maxElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.lock.lock();
            try {
                this.response = null;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Iterator<Object> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            this.lock.lock();
            try {
                int n = this.response == null ? 0 : 1;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Object peek() {
            this.lock.lock();
            try {
                Object object = this.response;
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Object getAndRemoveResponse() {
            Object value = this.response;
            this.response = null;
            return value == NULL ? null : value;
        }
    }
}

