/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.jmx;

import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanServer;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractChannelFactory;
import org.jacorb.notification.ConsoleMain;
import org.jacorb.notification.EventChannelFactoryImpl;
import org.jacorb.notification.jmx.COSNotificationServiceMBean;
import org.jacorb.notification.jmx.UnregisterObjectNameProviderDecorator;
import org.jacorb.notification.util.LogUtil;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXExposingComponentAdapterFactory;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.CachingComponentAdapterFactory;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;

public class COSNotificationService
implements COSNotificationServiceMBean {
    private AbstractChannelFactory factory_;
    private final MutablePicoContainer container_;
    private static final String STARTED = "EventChannelFactory was started";
    private static final String RUNNING = "EventChannelFactory is running";
    private static final String NOT_RUNNING = "EventChannelFactory is not running";
    private static final String STOPPED = "EventChannelFactory was stopped";
    private static final String IOR_DEFAULT = "IOR:0";
    private static final String CORBALOC_DEFAULT = "<undefined>";
    private final Logger logger_ = LogUtil.getLogger(this.getClass().getName());
    private final Properties properties_;
    private final ORB optionalORB_;

    public COSNotificationService(ORB oRB, MBeanServer mBeanServer, DynamicMBeanProvider dynamicMBeanProvider, String[] stringArray) {
        this.optionalORB_ = oRB;
        this.properties_ = ConsoleMain.parseProperties(stringArray);
        UnregisterObjectNameProviderDecorator unregisterObjectNameProviderDecorator = new UnregisterObjectNameProviderDecorator(mBeanServer, dynamicMBeanProvider);
        JMXExposingComponentAdapterFactory jMXExposingComponentAdapterFactory = new JMXExposingComponentAdapterFactory((ComponentAdapterFactory)new ConstructorInjectionComponentAdapterFactory(), mBeanServer, new DynamicMBeanProvider[]{unregisterObjectNameProviderDecorator});
        CachingComponentAdapterFactory cachingComponentAdapterFactory = new CachingComponentAdapterFactory((ComponentAdapterFactory)jMXExposingComponentAdapterFactory);
        this.container_ = new DefaultPicoContainer((ComponentAdapterFactory)cachingComponentAdapterFactory);
        this.container_.registerComponentInstance(ComponentAdapterFactory.class, (java.lang.Object)jMXExposingComponentAdapterFactory);
    }

    public String createChannel() {
        try {
            if (this.factory_ != null) {
                EventChannelFactoryImpl eventChannelFactoryImpl = (EventChannelFactoryImpl)this.factory_;
                IntHolder intHolder = new IntHolder();
                eventChannelFactoryImpl.create_channel(new Property[0], new Property[0], intHolder);
                return "Created Channel id=" + intHolder.value;
            }
            return NOT_RUNNING;
        }
        catch (Exception exception) {
            this.logger_.error("Error creating Channel", (Throwable)exception);
            throw new RuntimeException("Create channel failed: " + exception.getMessage());
        }
    }

    public String start() {
        if (this.factory_ != null) {
            return RUNNING;
        }
        try {
            this.factory_ = AbstractChannelFactory.newFactory(this.optionalORB_, this.container_, this.properties_);
            return STARTED;
        }
        catch (Exception exception) {
            this.logger_.error("Error starting Service", (Throwable)exception);
            throw new RuntimeException("Start failed: " + exception.getMessage());
        }
    }

    public String stop() {
        if (this.factory_ != null) {
            this.factory_.dispose();
            this.factory_ = null;
            return STOPPED;
        }
        return NOT_RUNNING;
    }

    public String getIOR() {
        return this.factory_ == null ? IOR_DEFAULT : this.factory_.getIOR();
    }

    public String getCorbaloc() {
        return this.factory_ == null ? CORBALOC_DEFAULT : this.factory_.getCorbaLoc();
    }

    public String getIORFile() {
        return this.properties_.getProperty("jacorb.notification.ior_file");
    }

    public void setIORFile(String string) throws IOException {
        this.properties_.setProperty("jacorb.notification.ior_file", string);
        if (this.factory_ != null) {
            this.factory_.writeIOR(string);
        }
    }

    public String getCOSNamingEntry() {
        StringBuffer stringBuffer = new StringBuffer(this.properties_.getProperty("jacorb.notification.register_name.id", CORBALOC_DEFAULT));
        String string = this.properties_.getProperty("jacorb.notification.register_name.kind");
        if (string != null) {
            stringBuffer.append('.');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setCOSNamingEntry(String string) {
        ConsoleMain.addCOSNamingName(this.properties_, string);
        if (this.factory_ != null) {
            try {
                this.factory_.unregisterName();
                this.factory_.registerName(this.properties_);
            }
            catch (Exception exception) {
                this.logger_.error("Error changing COSNaming entry", (Throwable)exception);
                throw new RuntimeException("Changing the COSNaming entry failed: " + exception.getMessage());
            }
        }
    }

    public Object getEventChannelFactory() {
        return this.factory_.activate();
    }
}

