/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;

public abstract class StaticNotifier {
    private static final long serialVersionUID = 1L;
    static Map notificationObjects = Collections.synchronizedMap(new HashMap());
    private static Log log = LogFactory.getLog((Class)StaticNotifier.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(String destination) {
        Object notificationObject;
        Object object = notificationObject = StaticNotifier.getNotificationObject(destination);
        synchronized (object) {
            log.trace((Object)("notifying one thread (" + destination + ", " + notificationObject + ")"));
            notificationObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForNotification(String destination) throws InterruptedException {
        try {
            Object notificationObject;
            Object object = notificationObject = StaticNotifier.getNotificationObject(destination);
            synchronized (object) {
                log.trace((Object)("going to wait for (" + destination + ", " + notificationObject + ")"));
                long timeout = JbpmConfiguration.Configs.getLong("jbpm.msg.wait.timout");
                notificationObject.wait(timeout);
            }
            log.trace((Object)"woke up");
        }
        catch (InterruptedException e) {
            log.trace((Object)"waiting for notification got interrupted");
            throw e;
        }
    }

    static synchronized Object getNotificationObject(String destination) {
        Object notificationObject = notificationObjects.get(destination);
        if (notificationObject == null) {
            notificationObject = new Object();
            notificationObjects.put(destination, notificationObject);
        }
        return notificationObject;
    }
}

