/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import org.apache.lucene.spatial.spatial4j.Geo3dPointShape;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPointShape;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;

public class Geo3dDistanceCalculator
implements DistanceCalculator {
    protected final PlanetModel planetModel;

    public Geo3dDistanceCalculator(PlanetModel planetModel) {
        this.planetModel = planetModel;
    }

    public double distance(Point from, Point to) {
        if (from instanceof Geo3dPointShape && to instanceof Geo3dPointShape) {
            GeoPointShape pointShape1 = (GeoPointShape)((Geo3dPointShape)from).shape;
            GeoPointShape pointShape2 = (GeoPointShape)((Geo3dPointShape)to).shape;
            return this.planetModel.surfaceDistance(pointShape1.getCenter(), pointShape2.getCenter()) * 57.29577951308232;
        }
        return this.distance(from, to.getX(), to.getY());
    }

    public double distance(Point from, double toX, double toY) {
        GeoPoint fromGeoPoint = from instanceof Geo3dPointShape ? ((GeoPointShape)((Geo3dPointShape)from).shape).getCenter() : new GeoPoint(this.planetModel, from.getY() * (Math.PI / 180), from.getX() * (Math.PI / 180));
        GeoPoint toGeoPoint = new GeoPoint(this.planetModel, toY * (Math.PI / 180), toX * (Math.PI / 180));
        return this.planetModel.surfaceDistance(fromGeoPoint, toGeoPoint) * 57.29577951308232;
    }

    public boolean within(Point from, double toX, double toY, double distance) {
        return distance < this.distance(from, toX, toY);
    }

    public Point pointOnBearing(Point from, double distDEG, double bearingDEG, SpatialContext ctx, Point reuse) {
        double \u03c3\u02b9;
        double cos\u03c3;
        double cos2\u03c3M;
        double sin\u03c3;
        double \u0394\u03c3;
        Geo3dPointShape geoFrom = (Geo3dPointShape)from;
        GeoPoint point = (GeoPoint)geoFrom.shape;
        double lat = point.getLatitude();
        double lon = point.getLongitude();
        double dist = Math.PI / 180 * distDEG;
        double bearing = Math.PI / 180 * bearingDEG;
        double sin\u03b11 = Math.sin(bearing);
        double cos\u03b11 = Math.cos(bearing);
        double tanU1 = (1.0 - this.planetModel.flattening) * Math.tan(lat);
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double \u03c31 = Math.atan2(tanU1, cos\u03b11);
        double sin\u03b1 = cosU1 * sin\u03b11;
        double cosSq\u03b1 = 1.0 - sin\u03b1 * sin\u03b1;
        double uSq = cosSq\u03b1 * this.planetModel.squareRatio;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double \u03c3 = dist / (this.planetModel.c * A);
        double iterations = 0.0;
        do {
            cos2\u03c3M = Math.cos(2.0 * \u03c31 + \u03c3);
        } while (Math.abs((\u03c3 = dist / (this.planetModel.c * A) + (\u0394\u03c3 = B * (sin\u03c3 = Math.sin(\u03c3)) * (cos2\u03c3M + B / 4.0 * ((cos\u03c3 = Math.cos(\u03c3)) * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M) - B / 6.0 * cos2\u03c3M * (-3.0 + 4.0 * sin\u03c3 * sin\u03c3) * (-3.0 + 4.0 * cos2\u03c3M * cos2\u03c3M))))) - (\u03c3\u02b9 = \u03c3)) > 1.0E-12 && (iterations += 1.0) < 200.0);
        if (iterations >= 200.0) {
            throw new RuntimeException("Formula failed to converge");
        }
        double x = sinU1 * sin\u03c3 - cosU1 * cos\u03c3 * cos\u03b11;
        double \u03c62 = Math.atan2(sinU1 * cos\u03c3 + cosU1 * sin\u03c3 * cos\u03b11, (1.0 - this.planetModel.flattening) * Math.sqrt(sin\u03b1 * sin\u03b1 + x * x));
        double \u03bb = Math.atan2(sin\u03c3 * sin\u03b11, cosU1 * cos\u03c3 - sinU1 * sin\u03c3 * cos\u03b11);
        double C = this.planetModel.flattening / 16.0 * cosSq\u03b1 * (4.0 + this.planetModel.flattening * (4.0 - 3.0 * cosSq\u03b1));
        double L = \u03bb - (1.0 - C) * this.planetModel.flattening * sin\u03b1 * (\u03c3 + C * sin\u03c3 * (cos2\u03c3M + C * cos\u03c3 * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M)));
        double \u03bb2 = (lon + L + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return ctx.getShapeFactory().pointXY(\u03bb2 * 57.29577951308232, \u03c62 * 57.29577951308232);
    }

    public Rectangle calcBoxByDistFromPt(Point from, double distDEG, SpatialContext ctx, Rectangle reuse) {
        Circle circle = ctx.getShapeFactory().circle(from, distDEG);
        return circle.getBoundingBox();
    }

    public double calcBoxByDistFromPt_yHorizAxisDEG(Point from, double distDEG, SpatialContext ctx) {
        throw new UnsupportedOperationException();
    }

    public double area(Rectangle rect) {
        throw new UnsupportedOperationException();
    }

    public double area(Circle circle) {
        throw new UnsupportedOperationException();
    }
}

