/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.assetkey.IndexInfoUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CVEMessageExtractor {
    public static String getDuplicateKeyAndValueMessage(String errorMsg) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(CVEMessageExtractor.getSpecNameFromErrorMessage(errorMsg));
        sb.append(".assetKey=");
        sb.append(CVEMessageExtractor.getDetailDuplicateMessage(errorMsg));
        return sb.toString();
    }

    private static String getSpecNameFromErrorMessage(String errorMsg) {
        Pattern pattern = Pattern.compile("\"(.*?)\"");
        Matcher matcher = pattern.matcher(errorMsg);
        if (!matcher.find()) {
            return null;
        }
        String uniqueIndexName = matcher.group(0);
        uniqueIndexName = uniqueIndexName.substring(1, uniqueIndexName.length() - 1);
        String[] tokens = uniqueIndexName.split(IdDAO.assetKeyTableUniqueIndexName);
        return tokens[tokens.length - 1].toUpperCase();
    }

    private static String getDetailDuplicateMessage(String errorMsg) {
        Pattern pattern = Pattern.compile("Key (.*)already exists");
        Matcher matcher = pattern.matcher(errorMsg);
        if (!matcher.find()) {
            return "";
        }
        String result = matcher.group(0);
        result = result.substring(4);
        result = result.split("already exists")[0];
        String[] tokens = result.split("=");
        String uniqueKeys = StringUtils.trim((String)tokens[0]);
        String uniqueValues = StringUtils.trim((String)tokens[1]);
        uniqueValues = uniqueValues.substring(1, uniqueValues.length() - 1);
        String[] keys = uniqueKeys.split(",");
        String[] values = uniqueValues.split(",");
        ArrayList<String> resultMessage = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            StringBuilder sb = new StringBuilder(50);
            sb.append(IndexInfoUtil.getXpathFromIndexFieldName(keys[i]));
            sb.append(" : ");
            sb.append(StringUtils.trim((String)values[i]));
            resultMessage.add(sb.toString());
        }
        return StringUtils.join(resultMessage, (String)",");
    }
}

