/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.google.common.collect.Sets;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class GetAllTitleListOperator {
    public void addTitleIdListIntoResultSet(Set<Set<Long>> titleIdsSet, Set<Long> titleIds) {
        if (!this.isHavingIntersection(titleIdsSet, titleIds)) {
            titleIdsSet.add(titleIds);
            return;
        }
        if (this.isAlreadyContainAll(titleIdsSet, titleIds)) {
            return;
        }
        Set<Long> intersectedSet = this.getTheIntersectionSet(titleIdsSet, titleIds);
        if (CollectionUtils.isEmpty(intersectedSet)) {
            return;
        }
        titleIdsSet.remove(intersectedSet);
        titleIdsSet.add((Set<Long>)Sets.union(intersectedSet, titleIds));
    }

    private boolean isHavingIntersection(Set<Set<Long>> titleIdsSet, Set<Long> titleIds) {
        boolean isIntersected = false;
        for (Set<Long> existingSet : titleIdsSet) {
            if (Sets.intersection(existingSet, titleIds).isEmpty()) continue;
            isIntersected = true;
            break;
        }
        return isIntersected;
    }

    private boolean isAlreadyContainAll(Set<Set<Long>> titleIdsSet, Set<Long> titleIds) {
        boolean isContailAll = false;
        for (Set<Long> existingSet : titleIdsSet) {
            if (!existingSet.containsAll(titleIds)) continue;
            isContailAll = true;
            break;
        }
        return isContailAll;
    }

    private Set<Long> getTheIntersectionSet(Set<Set<Long>> titleIdsSet, Set<Long> titleIds) {
        for (Set<Long> existingSet : titleIdsSet) {
            if (Sets.intersection(existingSet, titleIds).isEmpty()) continue;
            return existingSet;
        }
        return null;
    }
}

