/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.tandbergtv.metadatamanager.DocumentDAOHelper;
import com.tandbergtv.metadatamanager.assetkey.GetAllTitleListOperator;
import com.tandbergtv.metadatamanager.assetkey.PgQueryBuilder;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.postgresql.util.PGobject;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.w3c.dom.Document;

public class IdDAO {
    private HibernateTemplate template;
    public static String assetKeyTable = "mdm_asset_identifier";
    public static String documentIdColumn = "document_id";
    public static String assetIdColumn = "asset_id";
    public static String keysJsonColumn = "keys";
    private static final Logger logger = Logger.getLogger(IdDAO.class);
    public static String assetKeyTableUniqueIndexName = "idx_unique_mdm_identifier_";
    public static String WARNING_MSG = "Below title(s) have duplicate identifiers, please take action to correct them: ";

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    public boolean checkKeys(SearchCriteria criteria) {
        boolean exist = false;
        PgQueryBuilder builder = new PgQueryBuilder();
        String sql = builder.sqlForAssetUniquenessQuery(criteria);
        exist = this.executeQuery(sql).size() > 0;
        logger.debug((Object)("--------- Asset key uniqueness query=" + sql));
        return exist;
    }

    public void saveKeys(Map<Asset, String> data) {
        this.executeUpdate(data);
    }

    public void deleteKeys(Long rootAssetId) {
        this.executeDelete(rootAssetId);
    }

    public List<Long> getDocumentId(SearchCriteria criteria) {
        PgQueryBuilder builder = new PgQueryBuilder();
        String sql = builder.sqlForDocumentIdQuery(criteria);
        List<Long> ids = this.executeQuery(sql);
        logger.debug((Object)("--------- Asset search:Search for Doc Id query=" + sql));
        return ids;
    }

    public List<Document> getDocuments(SearchCriteria criteria) {
        PgQueryBuilder queryBuilder = new PgQueryBuilder();
        String sql = queryBuilder.sqlForFullDocumentQuery(criteria);
        Session session = this.template.getSessionFactory().getCurrentSession();
        List<Document> docs = DocumentDAOHelper.getDocuments((org.hibernate.Session)session, sql);
        logger.debug((Object)("--------- Asset search:Search for Full Doc query=" + sql));
        return docs;
    }

    private List<Long> executeQuery(final String queryStr) {
        final ArrayList<Long> ids = new ArrayList<Long>();
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                try (PreparedStatement statement = conn.prepareStatement(queryStr);){
                    ResultSet results = statement.executeQuery();
                    while (results.next()) {
                        ids.add(results.getLong(1));
                    }
                }
            }
        };
        this.doWork(work);
        return ids;
    }

    private void executeUpdate(final Map<Asset, String> data) {
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                StringBuilder sb = new StringBuilder();
                sb.append("insert into ");
                sb.append(assetKeyTable);
                sb.append("(");
                sb.append(documentIdColumn);
                sb.append(",");
                sb.append(assetIdColumn);
                sb.append(",");
                sb.append(keysJsonColumn);
                sb.append(")");
                sb.append(" values (?,?,?)");
                Set assets = data.keySet();
                try (PreparedStatement ps = conn.prepareStatement(sb.toString());){
                    for (Asset asset : assets) {
                        PGobject dataObject = new PGobject();
                        dataObject.setType("json");
                        dataObject.setValue((String)data.get(asset));
                        Asset root = asset.getRoot() != null ? asset.getRoot() : asset;
                        ps.setLong(1, root.getId());
                        ps.setLong(2, asset.getId());
                        ps.setObject(3, dataObject);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
            }
        };
        this.doWork(work);
    }

    private void executeDelete(final Long rootAssetId) {
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                StringBuilder sb = new StringBuilder();
                sb.append("delete from ");
                sb.append(assetKeyTable);
                sb.append(" where ");
                sb.append(documentIdColumn);
                sb.append("=?");
                try (PreparedStatement ps = conn.prepareStatement(sb.toString());){
                    ps.setLong(1, rootAssetId);
                    ps.execute();
                }
            }
        };
        this.doWork(work);
    }

    private void doWork(Work work) {
        Session session = this.template.getSessionFactory().getCurrentSession();
        try {
            session.doWork(work);
        }
        catch (RuntimeException e) {
            try {
                logger.error((Object)"error for doing work", (Throwable)e);
                session.cancelQuery();
            }
            catch (Exception e1) {
                logger.error((Object)"cancal query error", (Throwable)e1);
            }
            throw e;
        }
    }

    public String createUniqueIndex(String specAlias, Collection<String> ttvPaths) {
        logger.debug((Object)("Now handling spec : " + specAlias));
        String displayMsg = "";
        List<BigDecimal[]> duplicateAssetIds = this.queryForDuplicate(ttvPaths);
        if (!duplicateAssetIds.isEmpty()) {
            Set<Set<Long>> titleIds = this.getTitleIdsWithDuplicateAssetId(duplicateAssetIds);
            displayMsg = this.getDisplayTitleIdMessage(titleIds);
            logger.warn((Object)(WARNING_MSG + displayMsg));
            List<Long> toBeRemovedAssetIds = this.getToBeRemovedAssetIds(duplicateAssetIds);
            logger.info((Object)("Following Asset Id(s) are duplicate and will be removed: " + toBeRemovedAssetIds));
            this.removeDuplicatedAssetId(toBeRemovedAssetIds);
        }
        String indexName = assetKeyTableUniqueIndexName + specAlias;
        this.addUniqueIndex(indexName, ttvPaths);
        return displayMsg;
    }

    private String getDisplayTitleIdMessage(Set<Set<Long>> idSet) {
        ArrayList<String> resultMsg = new ArrayList<String>();
        for (Set<Long> ids : idSet) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("[");
            sb.append(StringUtils.join(ids, (String)","));
            sb.append("]");
            resultMsg.add(sb.toString());
        }
        return StringUtils.join(resultMsg, (String)",");
    }

    private List<Long> getToBeRemovedAssetIds(List<BigDecimal[]> duplicateList) {
        ArrayList<Long> toBeRemoved = new ArrayList<Long>();
        for (BigDecimal[] assetIdArray : duplicateList) {
            for (int i = 1; i < assetIdArray.length; ++i) {
                toBeRemoved.add(assetIdArray[i].longValue());
            }
        }
        return toBeRemoved;
    }

    private Set<Set<Long>> getTitleIdsWithDuplicateAssetId(List<BigDecimal[]> duplicateAssetIds) {
        HashSet<Set<Long>> titleIdsSet = new HashSet<Set<Long>>();
        Collections.sort(duplicateAssetIds, new Comparator<BigDecimal[]>(){

            @Override
            public int compare(BigDecimal[] o1, BigDecimal[] o2) {
                return o1.length - o2.length;
            }
        });
        GetAllTitleListOperator operator = new GetAllTitleListOperator();
        for (BigDecimal[] ids : duplicateAssetIds) {
            TreeSet<Long> titleIds = new TreeSet<Long>();
            for (BigDecimal id : ids) {
                PgQueryBuilder builder = new PgQueryBuilder();
                String sql = builder.sqlForQueryTitleIdFromAssetId();
                titleIds.addAll(this.executeQueryWithLongParm(sql, id.longValue()));
            }
            operator.addTitleIdListIntoResultSet(titleIdsSet, titleIds);
        }
        return titleIdsSet;
    }

    private List<BigDecimal[]> queryForDuplicate(Collection<String> ttvPaths) {
        PgQueryBuilder builder = new PgQueryBuilder();
        String sql = builder.sqlForQueryDuplicatedAssetId(ttvPaths);
        logger.debug((Object)("--------- Asset search:Search for duplicate asset id query=" + sql));
        return this.executeQueryForArray(sql);
    }

    private List<BigDecimal[]> executeQueryForArray(final String queryStr) {
        final ArrayList<BigDecimal[]> ids = new ArrayList<BigDecimal[]>();
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                try (PreparedStatement statement = conn.prepareStatement(queryStr);){
                    ResultSet results = statement.executeQuery();
                    while (results.next()) {
                        Array array = results.getArray(1);
                        Object[] assetIds = (BigDecimal[])array.getArray();
                        Arrays.sort(assetIds);
                        ids.add(assetIds);
                    }
                }
            }
        };
        this.doWork(work);
        return ids;
    }

    private List<Long> executeQueryWithLongParm(final String queryStr, final Long parm) {
        final ArrayList<Long> ids = new ArrayList<Long>();
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                statement.setLong(1, parm);
                try (PreparedStatement statement = conn.prepareStatement(queryStr);){
                    ResultSet results = statement.executeQuery();
                    if (results.next()) {
                        ids.add(results.getLong(1));
                    }
                }
            }
        };
        this.doWork(work);
        return ids;
    }

    private void executeDeleteByAssetId(final Long assetId) {
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                StringBuilder sb = new StringBuilder();
                sb.append("delete from ");
                sb.append(assetKeyTable);
                sb.append(" where ");
                sb.append(assetIdColumn);
                sb.append("=?");
                try (PreparedStatement ps = conn.prepareStatement(sb.toString());){
                    ps.setLong(1, assetId);
                    ps.execute();
                }
            }
        };
        this.doWork(work);
    }

    public void removeDuplicatedAssetId(List<Long> toBeRemovedAssetIds) {
        for (Long toBeRemoved : toBeRemovedAssetIds) {
            this.executeDeleteByAssetId(toBeRemoved);
        }
    }

    private void addUniqueIndex(final String indexName, final Collection<String> ttvPaths) {
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                PgQueryBuilder builder = new PgQueryBuilder();
                String sql = builder.sqlForCreateUniqueIndexOnIdentifiers(indexName, ttvPaths);
                logger.debug((Object)sql);
                try (PreparedStatement ps = conn.prepareStatement(sql);){
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        int value = 0;
                        if (rs.next()) {
                            value = rs.getInt(1);
                        }
                        if (value != 0) {
                            logger.warn((Object)"Create unique index is NOT successful, please check wfs.install_table for details.");
                        }
                    }
                }
            }
        };
        this.doWork(work);
    }

    public void deleteIndexes(final Set<String> indexNames) {
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                String dropIndexSql = "drop index if exists %s";
                try (Statement st = conn.createStatement();){
                    for (String name : indexNames) {
                        st.execute(String.format(dropIndexSql, name));
                    }
                }
            }
        };
        this.doWork(work);
    }
}

