/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.customfield.persistence;

import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.ICustomFieldDeleteCallback;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class CustomFieldPersistenceService
implements ICustomFieldPersistenceService {
    private static Logger logger = Logger.getLogger(CustomFieldPersistenceService.class);
    private HibernateTemplate template;
    private PlatformTransactionManager platformTxMgr;
    private static ICustomFieldPersistenceService instance;

    public PlatformTransactionManager getPlatformTxMgr() {
        return this.platformTxMgr;
    }

    public void setPlatformTxMgr(PlatformTransactionManager platformTxMgr) {
        this.platformTxMgr = platformTxMgr;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    public static synchronized ICustomFieldPersistenceService getInstance(ApplicationContext context) {
        if (instance == null) {
            instance = (ICustomFieldPersistenceService)context.getBean("customFieldPersistenceService");
        }
        return instance;
    }

    @Override
    @Transactional
    public List<CustomFieldGroup> getAllGroups() {
        return (List)this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery("select * from mdm_custom_field_group order by createdate").addEntity(CustomFieldGroup.class);
                return query.list();
            }
        });
    }

    @Override
    @Transactional
    public Map<String, List<CustomFieldGroup>> getAllGroupsPerAsset() {
        List<CustomFieldGroup> groups = this.getAllGroups();
        HashMap<String, List<CustomFieldGroup>> map = new HashMap<String, List<CustomFieldGroup>>();
        if (groups != null) {
            for (CustomFieldGroup group : groups) {
                String path = group.getAssetPath();
                ArrayList<CustomFieldGroup> list = (ArrayList<CustomFieldGroup>)map.get(path);
                if (list == null) {
                    list = new ArrayList<CustomFieldGroup>();
                    map.put(path, list);
                }
                list.add(group);
            }
        }
        return map;
    }

    public <T> T inHibernateSession(HibernateCallback callback) {
        return (T)this.getTemplate().executeWithNativeSession(callback);
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public static ICustomFieldPersistenceService getInstance() {
        return instance;
    }

    @Override
    @Transactional
    public void saveGroups(final List<CustomFieldGroup> groupList) throws CustomFieldDeleteCallbackException {
        final CustomFieldDeleteCallbackException[] exceptionHolder = new CustomFieldDeleteCallbackException[]{null};
        this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                try {
                    for (CustomFieldGroup group : groupList) {
                        if (group.getId() != null) {
                            CustomFieldGroup oldGroup = (CustomFieldGroup)session.get(CustomFieldGroup.class, (Serializable)group.getId());
                            List deleteFields = CustomFieldPersistenceService.this.getDeletedFields(oldGroup.getCustomFieldList(), group.getCustomFieldList());
                            CustomFieldPersistenceService.this.deleteFields(deleteFields, session);
                            CustomFieldPersistenceService.this.updateGroup(group, oldGroup, session);
                            session.saveOrUpdate((Object)oldGroup);
                            continue;
                        }
                        session.saveOrUpdate((Object)group);
                    }
                }
                catch (CustomFieldDeleteCallbackException e) {
                    logger.error((Object)("Could not save custom field groups: " + e));
                    exceptionHolder[0] = e;
                }
                catch (Exception e) {
                    logger.error((Object)("Could not save custom field groups: " + e));
                }
                return null;
            }
        });
        if (exceptionHolder[0] != null) {
            throw exceptionHolder[0];
        }
    }

    private void deleteFields(final List<CustomField> deleteFields, Session session) throws CustomFieldDeleteCallbackException {
        final ServiceLoader<ICustomFieldDeleteCallback> loader = ServiceLoader.load(ICustomFieldDeleteCallback.class);
        if (deleteFields != null) {
            try {
                for (CustomField field : deleteFields) {
                    Iterator<ICustomFieldDeleteCallback> serviceIterator = loader.iterator();
                    while (serviceIterator != null && serviceIterator.hasNext()) {
                        serviceIterator.next().beforeCustomFieldDelete(field);
                    }
                    Query query = session.createSQLQuery("delete from mdm_custom_field where custom_field_id = ?").addEntity(CustomField.class).setLong(0, field.getId().longValue());
                    query.executeUpdate();
                }
            }
            catch (CustomFieldDeleteCallbackException e) {
                logger.error((Object)("Could not delete custom field group: " + e));
                throw e;
            }
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (CustomField field : deleteFields) {
                        Iterator iter = loader.iterator();
                        while (iter != null && iter.hasNext()) {
                            try {
                                ((ICustomFieldDeleteCallback)iter.next()).afterCustomFieldDelete(field);
                            }
                            catch (CustomFieldDeleteCallbackException e) {
                                logger.error((Object)("Could not perform after delete operation for  custom field : " + field.getName() + " : " + e));
                            }
                        }
                    }
                }
            });
        }
    }

    private void updateGroup(CustomFieldGroup group, CustomFieldGroup oldGroup, Session session) {
        oldGroup.setDisplayName(group.getDisplayName());
        if (group.getCustomFieldList() != null && (oldGroup.getCustomFieldList() == null || oldGroup.getCustomFieldList().isEmpty())) {
            oldGroup.setCustomFieldList(group.getCustomFieldList());
        } else if (group.getCustomFieldList() != null) {
            for (CustomField field : group.getCustomFieldList()) {
                if (field.getId() != null) {
                    this.updateExistingField(oldGroup, field);
                    continue;
                }
                oldGroup.getCustomFieldList().size();
                oldGroup.getCustomFieldList().add(field);
                session.save((Object)field);
                session.merge((Object)oldGroup);
            }
        }
    }

    private void updateExistingFieldFromImport(CustomFieldGroup oldGroup, CustomField field) {
        for (CustomField oldField : oldGroup.getCustomFieldList()) {
            if (!oldField.getName().equalsIgnoreCase(field.getName())) continue;
            oldField.setDisplayName(field.getDisplayName());
            oldField.setFieldType(field.getFieldType());
            oldField.setJobParameter(field.getJobParameter());
            oldField.setMultiValue(field.getMultiValue());
            oldField.setJobScheduleParameter(this.validateJobScheduleParameter(field).getJobScheduleParameter());
        }
    }

    private List<CustomField> getDeletedFields(List<CustomField> oldList, List<CustomField> customFieldList) {
        ArrayList<CustomField> deleteList = new ArrayList<CustomField>();
        if (oldList != null) {
            for (CustomField oldField : oldList) {
                if (customFieldList != null) {
                    if (customFieldList.contains(oldField)) continue;
                    deleteList.add(oldField);
                    continue;
                }
                deleteList.add(oldField);
            }
        }
        return deleteList;
    }

    private void updateExistingField(CustomFieldGroup oldGroup, CustomField field) {
        for (CustomField oldField : oldGroup.getCustomFieldList()) {
            if (oldField.getId().longValue() != field.getId().longValue()) continue;
            oldField.setName(field.getName());
            oldField.setDisplayName(field.getDisplayName());
            oldField.setFieldType(field.getFieldType());
            oldField.setJobParameter(field.getJobParameter());
            oldField.setMultiValue(field.getMultiValue());
            oldField.setJobScheduleParameter(field.getJobScheduleParameter());
        }
    }

    @Override
    @Transactional
    public boolean validField(final String name, final String displayName, final String path, final String groupDisplayname) {
        return (Boolean)this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createSQLQuery("select * from mdm_custom_field where name = ?").addEntity(CustomField.class).setString(0, name);
                List list = query.list();
                if (list != null && !list.isEmpty()) {
                    for (CustomField field : list) {
                        if (!field.getGroup().getAssetPath().equalsIgnoreCase(path) || !field.getGroup().getDisplayName().equalsIgnoreCase(groupDisplayname) || !field.getDisplayName().equalsIgnoreCase(displayName)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    @Transactional
    public void deleteCustomField(final CustomField field) {
        this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                try {
                    CustomField customField = (CustomField)session.get(CustomField.class, (Serializable)field.getId());
                    session.delete((Object)customField);
                }
                catch (Exception e) {
                    logger.error((Object)("Could not delete custom field: " + e));
                }
                return null;
            }
        });
    }

    @Override
    @Transactional
    public void deleteCustomFieldGroup(final CustomFieldGroup group) {
        this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                try {
                    CustomFieldGroup oldGroup = (CustomFieldGroup)session.get(CustomFieldGroup.class, (Serializable)group.getId());
                    session.delete((Object)oldGroup);
                }
                catch (Exception e) {
                    logger.error((Object)("Could not delete custom field group: " + e));
                }
                return null;
            }
        });
    }

    @Override
    @Transactional
    public void deleteCustomFieldGroups(final List<CustomFieldGroup> deletedGroups) throws CustomFieldDeleteCallbackException {
        final CustomFieldDeleteCallbackException[] exceptionHolder = new CustomFieldDeleteCallbackException[]{null};
        final ServiceLoader<ICustomFieldDeleteCallback> loader = ServiceLoader.load(ICustomFieldDeleteCallback.class);
        this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                for (final CustomFieldGroup group : deletedGroups) {
                    try {
                        CustomFieldGroup oldGroup = (CustomFieldGroup)session.get(CustomFieldGroup.class, (Serializable)group.getId());
                        final List<CustomField> fieldList = oldGroup.getCustomFieldList();
                        if (fieldList != null) {
                            for (CustomField field : fieldList) {
                                Iterator serviceIterator = loader.iterator();
                                while (serviceIterator != null && serviceIterator.hasNext()) {
                                    ((ICustomFieldDeleteCallback)serviceIterator.next()).beforeCustomFieldDelete(field);
                                }
                                Query query = session.createSQLQuery("delete from mdm_custom_field where custom_field_id = ?").addEntity(CustomField.class).setLong(0, field.getId().longValue());
                                query.executeUpdate();
                            }
                        }
                        Query query = session.createSQLQuery("delete from mdm_custom_field_group where group_id = ?").addEntity(CustomFieldGroup.class).setLong(0, group.getId().longValue());
                        query.executeUpdate();
                        CustomFieldPersistenceService.this.execute(new Runnable(){

                            @Override
                            public void run() {
                                for (CustomField field : fieldList) {
                                    Iterator iter = loader.iterator();
                                    while (iter != null && iter.hasNext()) {
                                        try {
                                            ((ICustomFieldDeleteCallback)iter.next()).afterCustomFieldDelete(field);
                                        }
                                        catch (CustomFieldDeleteCallbackException e) {
                                            logger.error((Object)("Could not perform after delete operation for  custom field : " + field.getName() + " : " + e));
                                        }
                                    }
                                }
                                Iterator iter2 = loader.iterator();
                                while (iter2 != null && iter2.hasNext()) {
                                    try {
                                        ((ICustomFieldDeleteCallback)iter2.next()).afterCustomFieldGroupDelete(group);
                                    }
                                    catch (CustomFieldDeleteCallbackException e) {
                                        logger.error((Object)("Could not perform after delete operation for  custom field group: " + group.getName() + " : " + e));
                                    }
                                }
                            }
                        });
                    }
                    catch (CustomFieldDeleteCallbackException e) {
                        logger.error((Object)("Could not delete custom field group: " + e));
                        exceptionHolder[0] = e;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Could not delete custom field group: " + e));
                        exceptionHolder[0] = new CustomFieldDeleteCallbackException("Exception on delete custom field: " + e.getMessage());
                    }
                }
                return null;
            }
        });
        if (exceptionHolder[0] != null) {
            throw exceptionHolder[0];
        }
    }

    @Override
    @Transactional
    public int saveImportedCustomFields(final List<CustomFieldGroup> groupList) throws Exception {
        final Exception[] exceptionHolder = new Exception[]{null};
        final int[] isError = new int[]{0};
        this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                try {
                    for (CustomFieldGroup group : groupList) {
                        Query query = session.createSQLQuery("select * from mdm_custom_field_group where uuid = ? or (display_name = ? and asset_path = ?)").addEntity(CustomFieldGroup.class).setString(0, group.getUuid()).setString(1, group.getDisplayName()).setString(2, group.getAssetPath());
                        try {
                            CustomFieldGroup oldGroup = (CustomFieldGroup)query.uniqueResult();
                            if (oldGroup != null) {
                                if (group.getUuid() != null) {
                                    oldGroup.setUuid(group.getUuid());
                                }
                                group.setId(oldGroup.getId());
                                CustomFieldPersistenceService.this.updateImportedGroup(group, oldGroup, session);
                                session.saveOrUpdate((Object)oldGroup);
                                continue;
                            }
                            Iterator<CustomField> iter = group.getCustomFieldList().iterator();
                            while (iter.hasNext()) {
                                CustomField field = iter.next();
                                if (!CustomFieldPersistenceService.this.fieldExists(field.getName(), field.getGroup().getAssetPath())) continue;
                                iter.remove();
                                logger.error((Object)("Failed to Import as same field name exists in different group:" + field.getName()));
                                isError[0] = 1;
                            }
                            session.saveOrUpdate((Object)group);
                        }
                        catch (NonUniqueResultException e) {
                            logger.error((Object)("Failed to import group with conflicting Display Name: " + group.getDisplayName() + " and UUID: " + group.getUuid()));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Could not import/save custom field groups: " + e));
                    exceptionHolder[0] = e;
                }
                return null;
            }
        });
        if (exceptionHolder[0] != null) {
            throw exceptionHolder[0];
        }
        if (isError[0] == 1) {
            return 1;
        }
        return 0;
    }

    private void updateImportedGroup(CustomFieldGroup group, CustomFieldGroup oldGroup, Session session) {
        oldGroup.setDisplayName(group.getDisplayName());
        if (group.getCustomFieldList() != null) {
            for (CustomField field : group.getCustomFieldList()) {
                if (this.fieldExists(field.getName(), group.getAssetPath())) {
                    this.updateExistingFieldFromImport(oldGroup, field);
                    continue;
                }
                oldGroup.getCustomFieldList().size();
                field = this.validateJobScheduleParameter(field);
                oldGroup.getCustomFieldList().add(field);
                session.save((Object)field);
                session.merge((Object)oldGroup);
            }
        }
    }

    private boolean fieldExists(final String name, final String assetPath) {
        return (Boolean)this.inHibernateSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createSQLQuery("select * from mdm_custom_field where name = ?").addEntity(CustomField.class).setString(0, name);
                List list = query.list();
                if (list != null && !list.isEmpty()) {
                    for (CustomField field : list) {
                        if (!field.getGroup().getAssetPath().equalsIgnoreCase(assetPath)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private CustomField validateJobScheduleParameter(CustomField field) {
        if (field != null && field.getJobScheduleParameter() != null && !field.getDataType().equalsIgnoreCase("Date") && field.getJobScheduleParameter().equalsIgnoreCase("Y")) {
            field.setJobScheduleParameter("N");
        }
        return field;
    }

    private void execute(Runnable r) {
        new Thread(r).start();
    }
}

