/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetBooleanConditionBuilder;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetConditionBuilder;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetNumberConditionBuilder;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetStringConditionBuilder;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.pg.PgAssetStringConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.BooleanConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.ConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.DateConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.NumberConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.StringConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.TimeConditionBuilder;
import com.tandbergtv.metadatamanager.search.pg.PgDateConditionBuilder;
import com.tandbergtv.metadatamanager.search.pg.PgStringConditionBuilder;
import com.tandbergtv.metadatamanager.util.DBTypeEnum;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;

public class ConditionBuilderFactory {
    private SearchSchemaHelper searchSchemaHelper;

    public SearchSchemaHelper getSearchSchemaHelper() {
        return this.searchSchemaHelper;
    }

    public void setSearchSchemaHelper(SearchSchemaHelper searchSchemaHelper) {
        this.searchSchemaHelper = searchSchemaHelper;
    }

    private ConditionBuilder getConditionBuilder(DBTypeEnum dbType, Predicate predicate) {
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(predicate.getFieldLeft());
        ConditionBuilder result = dataType == null ? new ConditionBuilder(predicate) : (dataType.equals("integer") || dataType.equals("float") ? new NumberConditionBuilder(predicate) : (dataType.equals("string") ? (dbType == DBTypeEnum.ORACLE ? new StringConditionBuilder(predicate) : new PgStringConditionBuilder(predicate)) : (dataType.equals("time") ? new TimeConditionBuilder(predicate) : (dataType.equals("date") ? (dbType == DBTypeEnum.ORACLE ? new DateConditionBuilder(predicate) : new PgDateConditionBuilder(predicate)) : (dataType.equals("boolean") ? new BooleanConditionBuilder(predicate) : new ConditionBuilder(predicate))))));
        return this.initConditionBuilder(dbType, result);
    }

    private ConditionBuilder initConditionBuilder(DBTypeEnum dbType, ConditionBuilder result) {
        result.setSearchSchemaHelper(this.searchSchemaHelper);
        if (dbType == DBTypeEnum.ORACLE) {
            result.setStartsWithFunc("fn:starts-with");
            result.setXmlContains("contains(mdm.OBJECT_VALUE, 'HASPATH(");
            result.setXmlContainsEnds(")')");
            result.setXmlDateFormat("'fn:dateTime(xs:date(\"'yyyy-MM-dd'\"), xs:time(\"'HH:mm:ss'\"))'");
            result.setXmlExistsEnd("' passing sys_nc_rowinfo$ as \"p\")");
            result.setXmlExistsStart("xmlexists('$p");
            result.setXmlQueryForCustomField("xmlcast(XMLQUERY('");
            result.setXmlQueryReturn(" PASSING MDM.OBJECT_VALUE AS \"p\" RETURNING CONTENT) as varchar2(4000) ");
            result.setPathPrefix("$p");
        } else {
            result.setStartsWithFunc("starts-with");
            result.setXmlContains("array_length(xpath('");
            result.setXmlContainsEnds("',mdm.document),1)");
            result.setXmlDateFormat("yyyy-MM-dd");
            result.setXmlExistsEnd("' passing document)");
            result.setXmlExistsStart("xmlexists('");
            result.setXmlQueryForCustomField("(xmlpath('");
            result.setXmlQueryReturn("', mdm.document))[1]::varchar2(4000) ");
            result.setPathPrefix("");
        }
        return result;
    }

    public String getCondition(DBTypeEnum dbType, Predicate predicate) {
        ConditionBuilder conditionBuilder = this.getConditionBuilder(dbType, predicate);
        return conditionBuilder.getCondition();
    }

    public String getAssetCondition(DBTypeEnum dbType, Predicate predicate) {
        AssetConditionBuilder conditionBuilder = this.getAssertConditionBuilder(dbType, predicate);
        return conditionBuilder.getCondition();
    }

    private AssetConditionBuilder getAssertConditionBuilder(DBTypeEnum dbType, Predicate predicate) {
        boolean isOracle;
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(predicate.getFieldLeft());
        boolean bl = isOracle = dbType == DBTypeEnum.ORACLE;
        AssetConditionBuilder result = dataType == null ? new AssetConditionBuilder(predicate) : (dataType.equals("integer") || dataType.equals("float") ? new AssetNumberConditionBuilder(predicate) : (dataType.equals("string") ? (isOracle ? new AssetStringConditionBuilder(predicate) : new PgAssetStringConditionBuilder(predicate)) : (dataType.equals("boolean") ? new AssetBooleanConditionBuilder(predicate) : new AssetConditionBuilder(predicate))));
        result.setSearchSchemaHelper(this.getSearchSchemaHelper());
        if (isOracle) {
            result.setStartsWithFuncName("fn:starts-with");
            result.setEndsWithFuncName("fn:ends-with");
        } else {
            result.setStartsWithFuncName("starts-with");
            result.setEndsWithFuncName("ends-with");
        }
        return result;
    }
}

