/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.assetconditionbuilder;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import java.util.List;

public class AssetConditionBuilder {
    protected Predicate predicate;
    private SearchSchemaHelper searchSchemaHelper;
    private String startsWithFuncName = "fn:starts-with";
    private String endsWithFuncName = "fn:ends-with";

    public AssetConditionBuilder(Predicate predicate) {
        this.predicate = predicate;
    }

    public void setSearchSchemaHelper(SearchSchemaHelper searchSchemaHelper) {
        this.searchSchemaHelper = searchSchemaHelper;
    }

    public SearchSchemaHelper getSearchSchemaHelper() {
        return this.searchSchemaHelper;
    }

    protected boolean isCustomField() {
        return this.predicate.getFieldLeft().startsWith("/Fields/CustomFields/CustomField[@name=");
    }

    protected String getCustFieldName() {
        if (this.isCustomField()) {
            String field = this.predicate.getFieldLeft();
            return "@name=\"" + field.substring(39, field.indexOf("]")) + "\"";
        }
        return "";
    }

    protected String getCustomCriteria() {
        return this.getCustFieldName() + " and ";
    }

    protected String getRhsValue(int index) {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return SearchSchemaHelper.encodeValue((String)prv.getValue().get(index));
    }

    protected int getRhsValueCount() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue().size();
    }

    protected List<String> getValues() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue();
    }

    protected String getXpath() {
        StringBuilder xpath = new StringBuilder();
        boolean kindaCard1 = SearchSchemaHelper.assetTypeIsKindaHasCardinality1(this.predicate.getFieldLeftSectionType());
        if (kindaCard1) {
            xpath.append(this.searchSchemaHelper.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), false));
        }
        String field = this.predicate.getFieldLeft();
        if (this.isCustomField()) {
            field = CustomFieldXPathConverter.getActualXpath(field);
        }
        if (kindaCard1) {
            if (!field.startsWith("/")) {
                xpath.append("/");
            }
            xpath.append(field);
        } else if (field.startsWith("/")) {
            xpath.append(field.substring(1));
        } else {
            xpath.append(field);
        }
        return xpath.toString();
    }

    protected String inHelper(String conjunction, String operator) {
        int valueCnt = this.getRhsValueCount();
        if (valueCnt == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer();
        String xpath = this.getXpath();
        condition.append("(");
        for (int i = 0; i < valueCnt; ++i) {
            if (i > 0) {
                condition.append(" ");
                condition.append(conjunction);
                condition.append(" ");
            }
            condition.append(xpath);
            condition.append(operator);
            condition.append(this.getRhsValue(i));
        }
        condition.append(")");
        return condition.toString();
    }

    protected String simpleConditionHelper(String operator) {
        StringBuffer condition = new StringBuffer();
        condition.append(this.getXpath());
        condition.append(operator);
        condition.append(this.getRhsValue(0));
        return condition.toString();
    }

    protected String isEmpty() {
        StringBuffer condition = new StringBuffer();
        condition.append("not(");
        condition.append(this.getXpath());
        condition.append(")");
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" and  not(");
            if (SearchSchemaHelper.assetTypeIsKindaHasCardinality1(this.predicate.getFieldLeftSectionType())) {
                condition.append(this.searchSchemaHelper.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), false));
                condition.append("/");
            }
            condition.append("/UnparsableFields/UnparsableField");
            condition.append("[");
            condition.append(this.getStarstWithFuncName());
            condition.append("(");
            condition.append("@xpath");
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append("))");
        }
        return condition.toString();
    }

    protected String isNotEmpty() {
        StringBuffer condition = new StringBuffer();
        condition.append(this.getXpath());
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" or ");
            if (SearchSchemaHelper.assetTypeIsKindaHasCardinality1(this.predicate.getFieldLeftSectionType())) {
                condition.append(this.searchSchemaHelper.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), false));
                condition.append("/");
            }
            condition.append("/UnparsableFields/UnparsableField");
            condition.append("[");
            condition.append(this.getStarstWithFuncName());
            condition.append("(");
            condition.append("@xpath");
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(")");
        }
        return condition.toString();
    }

    protected String contains() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String endsWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String equal() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String greaterThan() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String greaterThanEqual() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String greaterThanToday() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String in() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String lessThan() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String lessThanEqual() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String lessThanToday() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notContains() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notEqual() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String startsWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notIn() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notLessThanToday() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notGreaterThanToday() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String between() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String doesNotEndWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String doesNotStartWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    public String getCondition() {
        switch (this.predicate.getSearchComplientOperator()) {
            case EQUAL: {
                return this.equal();
            }
            case NOTEQUAL: {
                return this.notEqual();
            }
            case LESSTHAN: {
                return this.lessThan();
            }
            case GREATERTHAN: {
                return this.greaterThan();
            }
            case LESSTHANEQUAL: {
                return this.lessThanEqual();
            }
            case GREATERTHANEQUAL: {
                return this.greaterThanEqual();
            }
            case ISNULL: {
                return this.isEmpty();
            }
            case ISNOTNULL: {
                return this.isNotEmpty();
            }
            case ISEMPTY: {
                return this.isEmpty();
            }
            case ISNOTEMPTY: {
                return this.isNotEmpty();
            }
            case CONTAINS: {
                return this.contains();
            }
            case DOESNOTCONTAIN: {
                return this.notContains();
            }
            case IN: {
                return this.in();
            }
            case NOTIN: {
                return this.notIn();
            }
            case STARTSWITH: {
                return this.startsWith();
            }
            case ENDSWITH: {
                return this.endsWith();
            }
            case DOESNOTSTARTWITH: {
                return this.doesNotStartWith();
            }
            case DOESNOTENDWITH: {
                return this.doesNotEndWith();
            }
            case GREATERTHANTODAY: {
                return this.greaterThanToday();
            }
            case LESSTHANTODAY: {
                return this.lessThanToday();
            }
            case NOTGREATERTHANTODAY: {
                return this.notGreaterThanToday();
            }
            case NOTLESSTHANTODAY: {
                return this.notLessThanToday();
            }
            case BETWEEN: {
                return this.between();
            }
        }
        throw new RuntimeException("Encountered the unsupported operator " + this.predicate.getSearchComplientOperator());
    }

    public String getStarstWithFuncName() {
        return this.startsWithFuncName;
    }

    public String getEndsWithFuncName() {
        return this.endsWithFuncName;
    }

    public String getStartsWithFuncName() {
        return this.startsWithFuncName;
    }

    public void setStartsWithFuncName(String startsWithFuncName) {
        this.startsWithFuncName = startsWithFuncName;
    }

    public void setEndsWithFuncName(String endsWithFuncName) {
        this.endsWithFuncName = endsWithFuncName;
    }
}

