/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.configuration.settings.client;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NeptuneServiceLocator {
    private static final Logger LOGGER = Logger.getLogger(NeptuneServiceLocator.class);
    private static final String DEFAULT_IP = "app";
    private static final String DEFAULT_IP_SSL = "https://app:8443";
    private static final String NEPTUNE_BASE_URL = "neptune_base_url";
    private static final String IS_NT_ENVIRONMENT = "is_NT_env";
    private static volatile Properties prop;

    private NeptuneServiceLocator() {
    }

    public static void setProp(Properties prop) {
        NeptuneServiceLocator.prop = prop;
        if (NeptuneServiceLocator.isLocalHost(prop.getProperty(NEPTUNE_BASE_URL))) {
            prop.remove(NEPTUNE_BASE_URL);
        }
    }

    private static boolean isLocalHost(String baseUrl) {
        String url = StringUtils.trimToEmpty((String)baseUrl);
        return url.startsWith("https://localhost:") || url.startsWith("http://localhost:");
    }

    public static String baseURL(boolean isUseSSLCert) {
        boolean isNTEnv = Boolean.parseBoolean(prop.getProperty(IS_NT_ENVIRONMENT, "false"));
        if (isUseSSLCert && !isNTEnv) {
            return DEFAULT_IP_SSL;
        }
        String baseUrl = NeptuneServiceLocator.getBaseURLFromConfig(prop);
        if (baseUrl != null) {
            return baseUrl;
        }
        return "https://" + NeptuneServiceLocator.getBaseIPFromHostName() + ":8443";
    }

    public static URL getBaseURL(boolean isUseSSLCert) {
        try {
            return new URL(NeptuneServiceLocator.baseURL(isUseSSLCert));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed to create access URL.", e);
        }
    }

    private static String getBaseURLFromConfig(Properties properties) {
        if (properties.isEmpty()) {
            LOGGER.debug((Object)"Cannot find the setting from property file");
        }
        return properties.getProperty(NEPTUNE_BASE_URL);
    }

    private static String getBaseIPFromHostName() {
        String ip = DEFAULT_IP;
        try {
            ip = InetAddress.getByName(DEFAULT_IP).getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.debug((Object)("Cannot find host id" + e.getMessage()));
        }
        return ip;
    }
}

