/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.i18n;

import com.ericsson.neptune.http.servlet.HttpServletUtil;
import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.ThreadScopeLocaleHolder;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LocaleFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(LocaleFilter.class);
    private static final String KEY_LOCALE_SERVICE = I18nResourceService.class.getName();

    public void destroy() {
        LOGGER.debug((Object)"locale filter destroyed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!HttpServletUtil.isHttpServlet(servletRequest, servletResponse)) {
            LOGGER.debug((Object)(LocaleFilter.class.getName() + " not interrupting the request since either request or response is not of HTTP type"));
            LOGGER.debug((Object)"Continuing with rest of the filters in the filter chain");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String localeKey = "locale";
        HttpSession session = request.getSession();
        Cookie localeCookie = I18nLocaleUtil.getCookie(request.getCookies(), localeKey);
        String localeSession = (String)session.getAttribute(localeKey);
        Set<String> providedLocales = this.getProvidedLocales(session.getServletContext());
        LOGGER.debug((Object)("locale in cookie: " + (localeCookie == null ? null : localeCookie.getValue()) + ", in session: " + localeSession));
        if (StringUtils.isBlank((String)localeSession) || this.shouldUpdateExistingLocale(localeCookie, localeSession, providedLocales)) {
            Object mutex;
            String newLocale = localeCookie == null ? "en_US" : localeCookie.getValue();
            Locale locale = I18nLocaleUtil.toLocale(newLocale);
            Object object = mutex = I18nLocaleUtil.getSessionMutex(session);
            synchronized (object) {
                session.setAttribute(localeKey, (Object)locale.toString());
                session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
                session.setAttribute("SessionLocaleResolver.LOCALE", (Object)locale);
            }
            LOGGER.debug((Object)("Setting locale to " + locale.toString() + " in http session."));
        }
        if (!session.getAttribute(localeKey).equals(I18nLocaleUtil.getThreadScopeLocaleValue())) {
            ThreadScopeLocaleHolder.getInstance().setThreadScopeLocale((String)session.getAttribute(localeKey));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void init(FilterConfig arg0) throws ServletException {
        LOGGER.debug((Object)"locale filter inited.");
    }

    private boolean shouldUpdateExistingLocale(Cookie localeCookie, String localeSession, Set<String> providedLocales) {
        boolean isLocaleCookieSameAsValidLocaleSession;
        boolean isValidLocaleCookieInProvidedLocales;
        boolean bl = isValidLocaleCookieInProvidedLocales = localeCookie != null && I18nLocaleUtil.validateLocale(providedLocales, localeCookie.getValue());
        if (!isValidLocaleCookieInProvidedLocales) {
            return false;
        }
        boolean bl2 = isLocaleCookieSameAsValidLocaleSession = I18nLocaleUtil.validateLocale(providedLocales, localeSession) && localeSession.equals(localeCookie.getValue());
        return !isLocaleCookieSameAsValidLocaleSession;
    }

    private I18nResourceService updateLocaleServiceInContext(ServletContext context) {
        I18nResourceService i18nResourceService = null;
        try {
            i18nResourceService = (I18nResourceService)InjectionUtil.injectInstance("cms/neptune/Neptune:service=com.tandbergtv.neptune.i18n.service.I18nResourceService");
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Cannot inject " + I18nResourceService.class.getName() + ", exception: " + e.getMessage()));
        }
        if (i18nResourceService == null) {
            LOGGER.warn((Object)("Got null " + I18nResourceService.class.getName() + " from EJB."));
            return null;
        }
        context.setAttribute(KEY_LOCALE_SERVICE, (Object)i18nResourceService);
        return i18nResourceService;
    }

    protected Set<String> getProvidedLocales(ServletContext context) {
        I18nResourceService i18nResourceService = null;
        try {
            i18nResourceService = (I18nResourceService)context.getAttribute(KEY_LOCALE_SERVICE);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Cannot get " + I18nResourceService.class.getName() + " Service from ServletContext.\n" + e.getMessage()));
        }
        if (i18nResourceService == null) {
            i18nResourceService = this.updateLocaleServiceInContext(context);
        }
        return I18nLocaleUtil.getLocaleMap(i18nResourceService).keySet();
    }
}

