/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.upgrade;

import com.tandbergtv.neptune.configuration.service.INeptuneUpgradeSettings;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class NeptuneSettingUpgrade
implements INeptuneUpgradeSettings {
    private ISettingsService settingsService;
    protected Map<String, String> beforeUpgradeMap = new HashMap<String, String>();
    protected Map<String, String> afterUpgradeMap = new HashMap<String, String>();
    protected String settingGroup;
    private List<String> upgradeKeys = new ArrayList<String>();

    @Override
    public Map<String, String> upgrade() {
        Map<String, String> neptuneMap = this.getSettings(this.settingGroup);
        for (String upgradeKey : this.upgradeKeys) {
            neptuneMap.put(upgradeKey, this.afterUpgradeMap.get(upgradeKey));
        }
        return neptuneMap;
    }

    @Override
    public void setFileName(String fileName) {
    }

    @Override
    public void setCMSBaseConfFolder(String confFolder) {
    }

    @Override
    public void upgradeApplied() {
    }

    @Override
    public boolean needsUpgrade() {
        Map<String, String> neptuneMap = this.getSettings(this.settingGroup);
        for (Map.Entry<String, String> entry : this.beforeUpgradeMap.entrySet()) {
            if (!entry.getValue().equals(neptuneMap.get(entry.getKey()))) continue;
            this.upgradeKeys.add(entry.getKey());
        }
        return !this.upgradeKeys.isEmpty();
    }

    protected Map<String, String> getSettings(String settingGroup) {
        return this.getSettingsService().getProperties(settingGroup);
    }

    private ISettingsService getSettingsService() {
        if (this.settingsService == null) {
            this.settingsService = InjectionUtil.injectInstance("cms/SettingsService/local", ISettingsService.class);
        }
        return this.settingsService;
    }
}

