/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class IntegerSettingValidator
extends AbstractSettingValidator {
    private static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");

    @Override
    public ValidationResult validate(SettingDefinition setting, String value) {
        ValidationResult result = new ValidationResult();
        if (value != null && !value.trim().isEmpty()) {
            try {
                new BigInteger(value);
            }
            catch (Exception e) {
                String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
                String displayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(setting.getPath(), setting.getDisplayName().get(0).getValue(), currentLocale);
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
                String message = ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("integerInvalid", defaultMessageBundle.getString("integerInvalid"), currentLocale);
                result.fail().addMessage("{0} " + message, currentLocale, params);
            }
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

