/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.StringBaseSettingType;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringPatternValidator
extends AbstractSettingValidator {
    private static Logger logger = Logger.getLogger(StringPatternValidator.class);
    private static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");

    @Override
    public ValidationResult validate(SettingDefinition s, String value) {
        ValidationResult result = new ValidationResult();
        if (!(s instanceof StringBaseSettingType)) {
            logger.warn((Object)"this validator cannot be applied on non-StringBaseSettingType, bypassing the validation.");
            result.success();
            return result;
        }
        StringBaseSettingType setting = (StringBaseSettingType)s;
        String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
        String displayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(setting.getPath(), setting.getDisplayName().get(0).getValue(), currentLocale);
        if (value != null && !value.trim().isEmpty() && setting.getRegex() != null && !Pattern.matches(setting.getRegex(), value.trim())) {
            ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
            params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
            String message = ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("stringFormatError", defaultMessageBundle.getString("stringFormatError"), currentLocale);
            result.fail().addMessage("{0} " + message, currentLocale, params);
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

