/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.service;

import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceServiceDelegate;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;

public class I18nLocaleService
extends I18nResourceServiceDelegate {
    private static final Logger LOGGER = Logger.getLogger(I18nLocaleService.class);

    @PostConstruct
    public void init() {
        try {
            this.start();
            LOGGER.debug((Object)(I18nLocaleService.class.getName() + " is started."));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to start I18nLocaleService.", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        try {
            this.stop();
            LOGGER.debug((Object)(I18nLocaleService.class.getName() + " is stopped."));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to stop I18nLocaleService.", (Throwable)e);
        }
    }

    public String getLocalizedLabel(String key, String defaultValue, String propertyGroupName, Locale locale) {
        MessageBundle messageBundle = super.getMessageBundleInstance();
        return messageBundle.getMessageValue(key, propertyGroupName, defaultValue, locale);
    }

    public String getLocalizedLabel(String localeKey, String defaultValue, String propertyGroupName, Locale locale, Object ... arguments) {
        MessageBundle messageBundle = super.getMessageBundleInstance();
        return messageBundle.getMessageValue(localeKey, propertyGroupName, defaultValue, locale, arguments);
    }
}

