/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.service.bundle;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.log4j.Logger;

public class ResourceBundleFileNameHelper {
    private static Logger logger = Logger.getLogger(ResourceBundleFileNameHelper.class);
    private String fileName;
    private String baseName;
    private Locale locale;
    private String suffix;

    private ResourceBundleFileNameHelper(String fileName, String baseName, Locale locale, String suffix) {
        this.fileName = fileName;
        this.baseName = baseName;
        this.locale = locale;
        this.suffix = suffix;
    }

    public static ResourceBundleFileNameHelper parseFileName(String fullName) {
        if (Strings.isNullOrEmpty((String)fullName)) {
            logger.error((Object)"File's full name is invalid!");
            return null;
        }
        String bundleName = Files.getNameWithoutExtension((String)fullName);
        if (Strings.isNullOrEmpty((String)bundleName)) {
            logger.error((Object)"bundle name is invalid!");
            return null;
        }
        return ResourceBundleFileNameHelper.createResourceBundleFileNameHelper(fullName, bundleName);
    }

    private static ResourceBundleFileNameHelper createResourceBundleFileNameHelper(String fullName, String bundleName) {
        ResourceBundleFileNameHelper resourceBundleFileNameHelper = null;
        String suffix = Files.getFileExtension((String)fullName);
        ArrayList names = Lists.newArrayList((Iterable)Splitter.on((String)"_").limit(2).split((CharSequence)bundleName));
        Locale locale = Locale.ROOT;
        try {
            locale = names.size() == 1 ? Locale.ROOT : LocaleUtils.toLocale((String)((String)names.get(1)));
            resourceBundleFileNameHelper = new ResourceBundleFileNameHelper(fullName, (String)names.get(0), locale, suffix);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("parse file name " + fullName + " failed . return empty helper"), (Throwable)e);
        }
        return resourceBundleFileNameHelper;
    }

    public static boolean validateFileName(String fileName) {
        return null != ResourceBundleFileNameHelper.parseFileName(fileName);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

