/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.service.io;

import com.tandbergtv.neptune.i18n.service.bundle.FileResourceBundle;
import com.tandbergtv.neptune.i18n.service.bundle.FileResourceBundleControl;
import com.tandbergtv.neptune.i18n.service.bundle.ResourceBundleFileNameHelper;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FileEventHandler {
    private Logger logger = Logger.getLogger(FileEventHandler.class);

    public void handleEvent(WatchEvent<?> event) {
        Path fileName = (Path)event.context();
        ResourceBundleFileNameHelper fileNameHelper = ResourceBundleFileNameHelper.parseFileName(fileName.toString());
        WatchEvent.Kind<?> kind = event.kind();
        if (kind == StandardWatchEventKinds.OVERFLOW || fileNameHelper == null) {
            return;
        }
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            this.logger.debug((Object)("file creation event received, file info:" + fileName.toString()));
            this.notifyResourceBundleCreate(fileNameHelper.getBaseName(), fileNameHelper.getLocale());
        }
        if (kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_DELETE) {
            this.logger.debug((Object)("file modified event received, file info:" + fileName.toString()));
            this.notifyResourceBundleModify(fileNameHelper.getBaseName(), fileNameHelper.getLocale());
        }
    }

    private void notifyResourceBundleCreate(String baseName, Locale locale) {
        FileResourceBundle.getBundleByParameter(baseName, locale);
    }

    private void notifyResourceBundleModify(String baseName, Locale locale) {
        FileResourceBundleControl.getInstance().reloadBundleAtNextVisit(baseName, locale);
    }
}

