/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.comm.routing.impl;

import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.message.util.XMLDocumentUtility;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WorkflowMessageConvertor {
    public WorkflowMessage toWorkflowMessage(IMessage msg) throws Exception {
        String xml = msg.getPayload().getContent();
        WorkflowMessage message = this.asWorkflowMessage(xml);
        WorkflowMessageConvertor.validateMessageUID(message);
        message.addAttachment(msg.getAttachment());
        return message;
    }

    private static void validateMessageUID(WorkflowMessage message) throws CommunicationException {
        String uidValue = message.getMessageUID().getUID();
        IMessageRegistry registry = ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getMessageRegistry();
        IMessageUID uid = registry.getMessageUID(uidValue);
        if (uid == null) {
            throw new CommunicationException("UID " + message.getMessageUID().getUID() + " not found in the message registry");
        }
    }

    public WorkflowMessage asWorkflowMessage(String xml) throws Exception {
        Document document = XMLDocumentUtility.loadXml((String)xml);
        return Unmarshaller.unmarshal((Document)document);
    }

    public WorkflowMessage asWorkflowMessage(Document document) throws MarshalException {
        return Unmarshaller.unmarshal((Document)document);
    }

    public MessageImpl toGenericMessage(WorkflowMessage message) throws IOException, MarshalException {
        String xmlString = this.asString(message);
        StringPayload payload = new StringPayload(xmlString);
        return new MessageImpl((IPayload)payload, message.getAttachment());
    }

    public String asString(WorkflowMessage message) throws IOException, MarshalException {
        Document document = Marshaller.newMarshaller().marshal(message);
        return XMLDocumentUtility.convertToString((Node)document);
    }

    public String asString(IMessage message) throws Exception {
        return this.asString(this.toWorkflowMessage(message));
    }
}

