/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.routing.impl.WorkflowMessageConvertor;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.command.ExecuteCommandCallable;
import com.tandbergtv.workflow.driver.command.buffer.IDelayedCommandService;
import com.tandbergtv.workflow.driver.command.locate.CompositeKeyMatcher;
import com.tandbergtv.workflow.driver.command.locate.RequestKeyLookup;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public abstract class BaseTokenCommand
extends AbstractCommand {
    private static final long serialVersionUID = 7303307342624622381L;
    private static final Logger LOGGER = Logger.getLogger(BaseTokenCommand.class);
    private static final int MAXDELAYCOUNT = 5000;
    private static final int MINUTES_10 = 10;
    private static final int EXPIRED_MINUTES = 10;
    private AtomicInteger delayCount;
    private static Cache<String, AtomicInteger> delayMessageCountCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    protected BaseTokenCommand(WorkflowMessage message) {
        super(message);
    }

    protected Token getToken() throws TokenLocatorException {
        IMessageKey key = this.message.getKey();
        if (key != null && key.toString().length() > 0) {
            return new RequestKeyLookup().locate(this.message);
        }
        return new CompositeKeyMatcher().locate(this.message);
    }

    protected CustomToken loadToken(WorkflowMessage msg) throws TokenLocatorException {
        long tokenId = Configuration.toLong((String)msg.getKey().toString(), (long)-1L);
        return this.loadToken(tokenId);
    }

    protected CustomToken loadToken(long tokenId) throws TokenLocatorException {
        CustomToken token = ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).getToken((Serializable)Long.valueOf(tokenId));
        if (token == null) {
            throw new TokenLocatorException("Invalid request key " + tokenId);
        }
        WorkflowProcess process = token.getProcessInstance();
        WorkflowProcessCache cache = ServiceLookup.findProcessCacheService();
        if (!process.hasEnded() && !cache.isInL1(process.getId())) {
            cache.add((Serializable)Long.valueOf(process.getId()), process);
        }
        return token;
    }

    protected abstract WorkflowMessage executeImpl(Token var1);

    public WorkflowMessage execute() {
        try {
            CustomToken token = (CustomToken)this.getToken();
            if (token == null) {
                return this.saveCommand();
            }
            if (!ProcessFinder.isOwner((WorkflowProcess)token.getProcessInstance())) {
                return this.executeCommandOnOwner(token);
            }
            this.checkStatus(token);
            if (!this.isReady(token)) {
                return this.saveCommand();
            }
            LOGGER.info((Object)("Located " + token + " for received message [" + this.message.getMessageUID() + "]"));
            this.saveRequest(this.message, token);
            return this.executeImpl((Token)token);
        }
        catch (TokenLocatorException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.logMessage(this.message);
            return this.createErrorResponse(e.getMessage());
        }
    }

    protected WorkflowMessage saveCommand() {
        IMessageUID uid = this.message.getMessageUID();
        try {
            this.delayCount = (AtomicInteger)delayMessageCountCache.get((Object)uid.getUID(), (Callable)new Callable<AtomicInteger>(){

                @Override
                public AtomicInteger call() {
                    return new AtomicInteger(1);
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn((Object)"Add delay count failed", (Throwable)e);
            return this.createErrorResponse("Add delay count failed,catch an ExecutionException: " + e.getMessage());
        }
        if (this.delayCount.get() >= 5000) {
            String warnMessage = "Failed to add Resource[" + uid + "] request to delayed buffer after " + 5000 + " retries in " + 10 + " Minute(s). Ignore the request until the next " + 10 + " Minutes(s)";
            LOGGER.warn((Object)warnMessage);
            return this.createErrorResponse(warnMessage);
        }
        IDelayedCommandService service = (IDelayedCommandService)ServiceRegistry.getDefault().lookup(IDelayedCommandService.class);
        if (service != null) {
            LOGGER.debug((Object)("Adding [" + uid + "] to delayed buffer"));
            service.addCommand((ICommand)this);
        }
        this.delayCount.getAndIncrement();
        return this.createSuccessResponse();
    }

    protected WorkflowMessage executeCommandOnOwner(CustomToken token) {
        this.getDistributedScheduler().schedule((Callable)((Object)new ExecuteCommandCallable(this.message, token)));
        return this.createSuccessResponse();
    }

    protected void checkStatus(CustomToken token) throws TokenLocatorException {
        ProcessStatus status = token.getStatus();
        if (status != ProcessStatus.BUSY && status != ProcessStatus.RUNNING && status != ProcessStatus.QUEUED) {
            throw new TokenLocatorException("Message [" + this.message.getMessageUID() + "]: found process " + token + ", status is unexpected");
        }
    }

    protected void saveRequest(WorkflowMessage message, CustomToken token) {
        Node node;
        if (message.getMessageUID().isMessageOutgoing()) {
            return;
        }
        ResourceManagement rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        Resource resource = rm.getResourceByToken(token.getId());
        if (resource == null && (node = token.getCurrentNode()) instanceof ResourceGroupAware) {
            String address = DeviceTypeUtil.getConnectionString((IDevice)message.getSource());
            Long id = ((ResourceGroupAware)node).getResourceGroupID();
            if (id != null) {
                LOGGER.debug((Object)(token + ", searching for resource in group " + id + " address " + address));
                resource = rm.getResourceByConnectionString(address, id.longValue());
            }
        }
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowMessageLogEvent((Token)token, token.getNode(), true, resource, message));
    }

    private boolean isReady(CustomToken token) {
        ResourceManagement rm;
        ResourceGroup group;
        if (token.getStatus() == ProcessStatus.QUEUED && !(group = this.getResourceGroup(rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class), (Token)token)).isInternallyAcquired()) {
            for (ResourceGroupQueueItem item : group.getQueue()) {
                if (item.getTokenId() != token.getId()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ResourceGroup getResourceGroup(ResourceManagement rm, Token token) {
        Node node = ((CustomToken)CustomToken.class.cast(token)).getCurrentNode();
        Long id = ((ResourceGroupAware)ResourceGroupAware.class.cast(node)).getResourceGroupID();
        if (id == null) {
            return null;
        }
        ResourceGroup group = null;
        try {
            group = rm.getResourceGroup(id.longValue());
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return group;
    }

    protected void logMessage(WorkflowMessage message) {
        try {
            String contents = new WorkflowMessageConvertor().asString(message);
            LOGGER.error((Object)("The message that failed to locate the token: " + contents));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to log the incoming message[" + message.getMessageUID() + "] that failed to locate a token."));
        }
    }

    protected IDistributedSchedulerService<CustomToken> getDistributedScheduler() {
        return (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("distributed-scheduler");
    }
}

