/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.driver.message.queue.FileMessageReader;
import com.tandbergtv.workflow.driver.message.queue.IFileMessageConsumer;
import com.tandbergtv.workflow.driver.message.queue.IFileWatcher;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class NIOWatchServiceFileWatcher
implements IFileWatcher {
    private static final Logger LOGGER = Logger.getLogger(NIOWatchServiceFileWatcher.class);
    private WatchService watchService;
    private IFileMessageConsumer consumer;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void setFileMessageConsumer(IFileMessageConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void start() {
        Assert.notNull((Object)this.consumer, (String)"Cannot find File message  Consumer");
        Path path = Paths.get(this.consumer.getWorkDir(), new String[0]);
        this.closeWatchService();
        try {
            this.watchService = path.getFileSystem().newWatchService();
            path.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    NIOWatchServiceFileWatcher.this.handleEvent();
                }
            });
        }
        catch (IOException e) {
            LOGGER.error((Object)("Failed to create watch service for folder" + this.consumer.getWorkDir()), (Throwable)e);
        }
    }

    private void handleEvent() {
        try {
            WatchKey key;
            while ((key = this.watchService.take()) != null) {
                if (this.isXmlFile(key)) {
                    new FileMessageReader().scan(this.consumer);
                }
                key.reset();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)("Stop the watching to folder" + this.consumer.getWorkDir()), (Throwable)e);
        }
    }

    private boolean isXmlFile(WatchKey key) {
        for (WatchEvent<?> event : key.pollEvents()) {
            LOGGER.debug((Object)("a new file coming:" + event.kind() + ". File affected: " + event.context() + "."));
            if (!event.context().toString().endsWith(".xml")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.executorService.shutdown();
        this.closeWatchService();
    }

    private void closeWatchService() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

