/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.driver.message.queue.FileMessageReader;
import com.tandbergtv.workflow.driver.message.queue.IFileMessageConsumer;
import com.tandbergtv.workflow.driver.message.queue.IFileWatcher;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class TimerFileWatcher
implements IFileWatcher {
    private static final Logger LOGGER = Logger.getLogger(TimerFileWatcher.class);
    private IFileMessageConsumer consumer;
    private AtomicInteger runCounter = new AtomicInteger(0);
    private AtomicInteger noDataRunCounter = new AtomicInteger(0);
    private long defaultSleepInterval = 1000L;
    boolean stopped = false;

    public void setDefaultSleepInterval(long defaultSleepInterval) {
        this.defaultSleepInterval = defaultSleepInterval;
    }

    @Override
    public void start() throws InterruptedException {
        Long sleepInteval = this.defaultSleepInterval;
        while (!this.stopped) {
            if (this.runCounter.get() >= 50) {
                this.runCounter.set(0);
            }
            this.runCounter.incrementAndGet();
            try {
                long handeledNumber = new FileMessageReader().scan(this.consumer);
                if (handeledNumber <= 0L && this.runCounter.get() > 30) {
                    this.noDataRunCounter.incrementAndGet();
                    sleepInteval = this.defaultSleepInterval + this.defaultSleepInterval * (long)this.noDataRunCounter.get();
                    LOGGER.debug((Object)("No Message files found, increase the sleep time to " + sleepInteval + "ms."));
                } else {
                    this.noDataRunCounter.set(0);
                    sleepInteval = this.defaultSleepInterval;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unexepected execption happended during the clean process", (Throwable)e);
            }
            Thread.sleep(sleepInteval);
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public void setFileMessageConsumer(IFileMessageConsumer consumer) {
        this.consumer = consumer;
    }
}

