/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.i18n;

import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceServiceDelegate;
import com.tandbergtv.workflow.i18n.I18nService;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class I18nServiceImpl
implements I18nService {
    private static final Logger LOGGER = Logger.getLogger(I18nServiceImpl.class);
    private I18nResourceServiceDelegate i18nResourceServiceDelegate = new I18nResourceServiceDelegate();

    public String getServiceName() {
        return I18nServiceImpl.class.getName();
    }

    public void start() {
        this.i18nResourceServiceDelegate.start();
        LOGGER.debug((Object)(I18nServiceImpl.class.getName() + " is started."));
    }

    public void stop() {
        this.i18nResourceServiceDelegate.stop();
        LOGGER.debug((Object)(I18nServiceImpl.class.getName() + " is stopped."));
    }

    public Map<String, String> getAvailableLanguageMap() {
        return this.i18nResourceServiceDelegate.getAvailableLanguageMap();
    }

    public MessageBundle getMessageBundleInstance() {
        return this.i18nResourceServiceDelegate.getMessageBundleInstance();
    }

    public List<ResourceBundle> getAvilableBundles() {
        return this.i18nResourceServiceDelegate.getAvilableBundles();
    }

    public List<ResourceBundle> getAvilableBundles(Locale locale) {
        return this.i18nResourceServiceDelegate.getAvilableBundles(locale);
    }

    public Set<Locale> getAvailableLocales() {
        return this.i18nResourceServiceDelegate.getAvailableLocales();
    }

    public Set<String> getNeptuneSettingMappingBundleNames() {
        return this.i18nResourceServiceDelegate.getNeptuneSettingMappingBundleNames();
    }

    @Override
    public String getClasspathMessage(String key, String baseName) {
        ResourceBundle bundle = this.getClasspathBundle(baseName);
        if (bundle == null) {
            LOGGER.warn((Object)("Failed to get " + ResourceBundle.class.getName() + " by baseName " + baseName));
            return "";
        }
        try {
            return bundle.getString(key);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to get message " + baseName + " by key " + key + " from classpath\n" + e.getMessage()));
            return "";
        }
    }

    @Override
    public ResourceBundle getClasspathBundle(String baseName) {
        try {
            return ResourceBundle.getBundle(baseName, Locale.ROOT);
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage());
            return null;
        }
    }
}

