/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.unit.TimeValue;

public class GarbageCollector
implements Runnable {
    private static final String INDEX_PREFIX = "history_logs_";
    private static final long TIMEOUT_MS = 30000L;
    private Long window;
    private static final Logger LOGGER = Logger.getLogger(GarbageCollector.class);
    private TransportClient client;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public GarbageCollector(Long window, TransportClient client) {
        this.window = window;
        this.client = client;
    }

    @Override
    public void run() {
        Date date = this.getCutoffDate();
        AdminClient admin = this.client.admin();
        try {
            MetaData metadata = ((ClusterStateResponse)admin.cluster().prepareState().get(TimeValue.timeValueMillis((long)30000L))).getState().getMetaData();
            for (String index : metadata.getConcreteAllIndices()) {
                if (!this.shouldBeDeleted(index, date)) continue;
                LOGGER.debug((Object)("Deleting process history index : " + index));
                admin.indices().delete(new DeleteIndexRequest(index));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"There was an error when getting a list of indexes.");
        }
    }

    private boolean shouldBeDeleted(String index, Date date) {
        if (!index.contains(INDEX_PREFIX)) {
            return false;
        }
        String indexDate = index.substring(INDEX_PREFIX.length());
        try {
            Date date1 = this.toDateOnly(indexDate);
            Date cutoff = this.toDateOnly(this.sdf.format(date));
            if (date1.before(cutoff)) {
                return true;
            }
        }
        catch (ParseException e) {
            LOGGER.warn((Object)("There is a parse error in the date format of the index " + index));
        }
        return false;
    }

    private Date toDateOnly(String dateStr) throws ParseException {
        return this.sdf.parse(dateStr);
    }

    private Date getCutoffDate() {
        return new Date(System.currentTimeMillis() - this.window * 1000L);
    }
}

