/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.ratelimiter;

import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.process.ratelimiter.IRateLimiter;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class RateLimiterProviderLoader {
    private static final Logger logger = Logger.getLogger(RateLimiterProviderLoader.class);
    private static final String PROVIDER_EXTENSION_POINT = "ratelimiterProvider";
    private static final String PLUGIN = "com.tandbergtv.workflow.ratelimiter";

    public IRateLimiter createRatelimterPlugin() {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = this.loadPoint(pm);
        if (point == null || point.getAvailableExtensions().isEmpty()) {
            return null;
        }
        IRateLimiter provider = null;
        Extension extension = (Extension)point.getAvailableExtensions().iterator().next();
        String className = extension.getParameter("class").valueAsString();
        PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
        try {
            Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
            provider = (IRateLimiter)clazz.newInstance();
            logger.info((Object)("Loaded RateLimiter provider from plugin definiton for : " + className));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to load RateLimiter Provider for : " + className), (Throwable)e);
        }
        return provider;
    }

    private ExtensionPoint loadPoint(PluginManager pm) {
        ExtensionPoint point = null;
        try {
            point = pm.getRegistry().getExtensionPoint(PLUGIN, PROVIDER_EXTENSION_POINT);
        }
        catch (Exception e) {
            logger.debug((Object)("Failed to find customized RateLimiter Plugin definiton: on com.tandbergtv.workflow.ratelimiter,error:" + e.getMessage()));
        }
        return point;
    }
}

