/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.boot.ILicenseProvider;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import com.tandbergtv.workflow.settings.SettingParser;
import com.tandbergtv.workflow.util.LicenseProviderFactory;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RemoteSettingsUpdateNotificationService
implements Service {
    private static final Logger LOGGER = Logger.getLogger(RemoteSettingsUpdateNotificationService.class);
    private static final long DEFAULT_DELAY = 5L;
    private static final long DEFAULT_REFRESH_INTERVAL = 300L;
    private volatile ISettingsProvider settingsProvider;
    private long delay = 5L;
    private long interval = 300L;
    private List<ISettingUpdateListenter> updateListeners = Lists.newArrayList();
    private Map<String, String> settingCache = Maps.newConcurrentMap();
    private Scheduler<Void> notificationScheduler = new Scheduler("RemoteSettingsUpdateNotificationService", 2, 10);

    protected Map<String, String> getSetting(String path) {
        return new SettingParser().getSetting(this.settingCache, path);
    }

    public void start() {
        this.interval = Configuration.toLong((String)System.getProperty("remoteSetting.refresh.interval"), (long)this.interval);
        this.notificationScheduler.schedule(() -> {
            this.handleNeptuneSetting();
            this.handleLicenseSetting();
        }, this.delay * 1000L, this.interval * 1000L);
    }

    private void handleNeptuneSetting() {
        if (this.getSettingsProvider() == null) {
            LOGGER.warn((Object)"NeptuneSettingsProvider is not properly setup, cannot get settings");
            return;
        }
        for (String path : this.getNeptuneSettingFetchPath()) {
            try {
                String newValue;
                String oldValue = this.settingCache.get(path);
                if (!this.isValueChanged(oldValue, newValue = this.getSettingsProvider().getPropertiesAsJSON(path))) continue;
                this.settingCache.put(path, newValue);
                LOGGER.debug((Object)("The setting[" + path + "] updated with value[" + newValue + "]"));
                this.notifyChanges(path);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Refreshing Neptune setting[" + path + "] fail"), (Throwable)e);
            }
        }
    }

    private Set<String> getNeptuneSettingFetchPath() {
        LinkedHashSet paths = Sets.newLinkedHashSet();
        for (ISettingUpdateListenter listenter : this.updateListeners) {
            if ("WF_LICENSE_SETTING".equals(listenter.getPath())) continue;
            paths.add(listenter.getPath());
        }
        return paths;
    }

    private void handleLicenseSetting() {
        ILicenseProvider provider = LicenseProviderFactory.getLicenseProvider();
        if (provider == null) {
            LOGGER.warn((Object)"ILicenseProvider is not properly setup, cannot get settings");
            return;
        }
        try {
            Properties properties = provider.getProperties();
            String oldValue = this.settingCache.get("WF_LICENSE_SETTING");
            String newValue = new SettingParser().getSettingAsString(properties);
            if (this.isValueChanged(oldValue, newValue)) {
                this.settingCache.put("WF_LICENSE_SETTING", newValue);
                LOGGER.debug((Object)("setting[WF_LICENSE_SETTING] updated with value[" + newValue + "]"));
                this.notifyChanges("WF_LICENSE_SETTING");
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"refreshing Neptune setting[WF_LICENSE_SETTING] fail", (Throwable)e);
        }
    }

    private boolean isValueChanged(String oldValue, String newValue) {
        return oldValue == null || !StringUtils.equals((String)oldValue, (String)newValue);
    }

    private void notifyChanges(String path) {
        Map<String, String> setting = this.getSetting(path);
        for (ISettingUpdateListenter listener : this.updateListeners) {
            if (!path.equals(listener.getPath())) continue;
            this.notificationScheduler.schedule(() -> {
                try {
                    listener.changed(setting);
                }
                catch (Exception e) {
                    String msg = "Failed to notify the listener:" + listener.getPath() + "/" + listener.getClass().getName() + ". due to " + e.getMessage();
                    LOGGER.warn((Object)msg);
                    this.settingCache.remove(path);
                }
                return null;
            });
        }
    }

    public void stop() {
        this.notificationScheduler.stop();
    }

    public String getServiceName() {
        return RemoteSettingsUpdateNotificationService.class.getName();
    }

    protected ISettingsProvider getSettingsProvider() {
        if (this.settingsProvider == null) {
            this.settingsProvider = new SettingsPluginLoader().createSettingsProvider();
        }
        return this.settingsProvider;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void addUpdateListener(ISettingUpdateListenter listener) {
        this.updateListeners.add(listener);
    }
}

