/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.message.util.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDocumentUtility {
    private static final Logger LOGGER = Logger.getLogger(XMLDocumentUtility.class);

    protected static DocumentBuilder getDocBuilder(boolean validating, boolean nameware) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (validating) {
                factory.setValidating(validating);
            }
            factory.setNamespaceAware(nameware);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)"Failed to create DocumentBuilder", (Throwable)e);
            throw new DOMException(9, e.getMessage());
        }
    }

    public static void setNodeValue(String expression, String value, XPath xPath, Node n) throws Exception {
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        node.setTextContent(value);
    }

    public static String getNodeValue(String expression, XPath xPath, Node n) throws Exception {
        if (expression.substring(0, 1).equals("$")) {
            return expression.substring(1);
        }
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        return node != null ? node.getTextContent() : "";
    }

    public static NodeList getNodeSet(String expression, XPath xPath, org.w3c.dom.Document doc) throws Exception {
        return (NodeList)xPath.evaluate(expression, doc, XPathConstants.NODESET);
    }

    public static String convertToString(Node node, String encoding) throws IOException {
        return XMLDocumentUtility.convertToString(node, encoding, false);
    }

    public static String convertToString(Node node, boolean suppressDeclaration) throws IOException {
        org.w3c.dom.Document w3cDOM = node instanceof org.w3c.dom.Document ? (org.w3c.dom.Document)org.w3c.dom.Document.class.cast(node) : node.getOwnerDocument();
        OutputFormat format = XMLDocumentUtility.createFormat(w3cDOM.getXmlEncoding(), false);
        format.setSuppressDeclaration(suppressDeclaration);
        return XMLDocumentUtility.convertToString(node, format);
    }

    public static String convertToString(Node node, boolean pretty, boolean suppressDeclaration) throws IOException {
        org.w3c.dom.Document w3cDOM = node instanceof org.w3c.dom.Document ? (org.w3c.dom.Document)org.w3c.dom.Document.class.cast(node) : node.getOwnerDocument();
        OutputFormat format = XMLDocumentUtility.createFormat(w3cDOM.getXmlEncoding(), pretty);
        format.setSuppressDeclaration(suppressDeclaration);
        return XMLDocumentUtility.convertToString(node, format);
    }

    public static String convertToString(Node node) throws IOException {
        org.w3c.dom.Document w3cDOM = node instanceof org.w3c.dom.Document ? (org.w3c.dom.Document)org.w3c.dom.Document.class.cast(node) : node.getOwnerDocument();
        return XMLDocumentUtility.convertToString(node, w3cDOM.getXmlEncoding());
    }

    public static String convertToString(Node node, String encoding, boolean pretty) throws IOException {
        return XMLDocumentUtility.convertToString(node, XMLDocumentUtility.createFormat(encoding, pretty));
    }

    private static String convertToString(Node node, OutputFormat format) throws IOException {
        Document document = XMLDocumentUtility.getDom4jDoc(node);
        StringWriter w = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)w, format);
        xmlWriter.write(document);
        return w.getBuffer().toString().trim();
    }

    private static boolean isBlank(String xmlContent) {
        return xmlContent == null || xmlContent.trim().length() == 0;
    }

    private static OutputFormat createFormat(String encoding, boolean pretty) {
        OutputFormat format = pretty ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        format.setNewLineAfterDeclaration(false);
        if (pretty) {
            format.setIndentSize(4);
        }
        format.setEncoding(encoding);
        return format;
    }

    private static Document getDom4jDoc(Node node) {
        org.w3c.dom.Document w3cDOM = node instanceof org.w3c.dom.Document ? (org.w3c.dom.Document)org.w3c.dom.Document.class.cast(node) : node.getOwnerDocument();
        return new DOMReader().read(w3cDOM);
    }

    public static org.w3c.dom.Document loadXml(String xmlString) throws SAXException, IOException {
        DocumentBuilder builder = XMLDocumentUtility.getDocBuilder(false, false);
        return builder.parse(new InputSource(new StringReader(xmlString)));
    }

    public static org.w3c.dom.Document loadXml(String xmlString, boolean isNSAware) throws Exception {
        DocumentBuilder builder = XMLDocumentUtility.getDocBuilder(false, isNSAware);
        return builder.parse(new InputSource(new StringReader(xmlString)));
    }

    public static org.w3c.dom.Document loadFile(ClassLoader classloader, String filePath, boolean validating) throws SAXException, IOException {
        return XMLDocumentUtility.loadFile(classloader.getResourceAsStream(filePath), validating, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static org.w3c.dom.Document loadFile(InputStream stream, boolean validating, boolean nameSpaceAware) throws SAXException, IOException {
        try {
            org.w3c.dom.Document document = XMLDocumentUtility.getDocBuilder(validating, nameSpaceAware).parse(stream);
            return document;
        }
        finally {
            ResourceUtil.quietClose(stream);
        }
    }

    public static org.w3c.dom.Document loadFile(String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(XMLDocumentUtility.class.getClassLoader(), filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.w3c.dom.Document loadFile(File file) throws SAXException, IOException {
        DocumentBuilder builder = XMLDocumentUtility.getDocBuilder(false, false);
        FileInputStream fis = new FileInputStream(file);
        try {
            org.w3c.dom.Document document = builder.parse(new InputSource(fis));
            return document;
        }
        finally {
            ResourceUtil.quietClose(fis);
        }
    }

    public static org.w3c.dom.Document loadFile(ClassLoader classloader, String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(classloader, filePath, false);
    }

    public static org.w3c.dom.Document loadFile(ClassLoader classloader, String filePath, boolean validating, boolean nameSpaceAware) throws SAXException, IOException {
        return XMLDocumentUtility.loadFile(classloader.getResourceAsStream(filePath), validating, nameSpaceAware);
    }

    public static Schema loadSchema(String path) throws SAXException {
        Schema schema;
        InputStream stream = null;
        try {
            stream = XMLDocumentUtility.class.getClassLoader().getResourceAsStream(path);
            schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
        }
        catch (Throwable throwable) {
            ResourceUtil.quietClose(stream);
            throw throwable;
        }
        ResourceUtil.quietClose(stream);
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(org.w3c.dom.Document document, String filePath) throws IOException {
        DOMReader domReader = new DOMReader();
        Document dom4jDoc = domReader.read(document);
        OutputFormat format = XMLDocumentUtility.createFormat(document.getXmlEncoding(), true);
        XMLWriter xmlWriter = null;
        try {
            FileOutputStream fos = new FileOutputStream(new File(filePath));
            xmlWriter = new XMLWriter((OutputStream)fos, format);
            xmlWriter.write(dom4jDoc);
            xmlWriter.flush();
        }
        catch (Throwable throwable) {
            ResourceUtil.quietClose(xmlWriter);
            throw throwable;
        }
        ResourceUtil.quietClose(xmlWriter);
    }

    public static String pretty(String xmlContent) {
        return XMLDocumentUtility.pretty(xmlContent, false);
    }

    public static String pretty(String xmlContent, boolean suppressDeclaration) {
        if (XMLDocumentUtility.isBlank(xmlContent)) {
            return xmlContent;
        }
        String prettyXml = xmlContent;
        try {
            Document doc = DocumentHelper.parseText((String)xmlContent);
            StringWriter sw = new StringWriter();
            OutputFormat format = XMLDocumentUtility.createFormat(doc.getXMLEncoding(), true);
            format.setSuppressDeclaration(suppressDeclaration);
            XMLWriter xw = new XMLWriter((Writer)sw, format);
            xw.write(doc);
            return sw.toString();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Failed to load/parse the XML.\n" + xmlContent), (Throwable)ex);
            return prettyXml;
        }
    }
}

