/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.CurrentNodeVisitor;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.SimpleComment;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import com.tandbergtv.workflow.core.entity.TaskInstanceDTO;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import com.tandbergtv.workflow.core.util.Reflection;
import com.tandbergtv.workflow.driver.internal.TaskInstanceConvertor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.Token;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CustomTokenConvertor {
    private static final String VARIABLE_TYPE = "type";
    private static final String VARIABLE_VALUE = "value";
    private final Logger logger = Logger.getLogger(CustomTokenConvertor.class);
    private TaskInstanceConvertor taskInstanceConvertor;

    public CustomTokenConvertor(TaskInstanceConvertor taskInstanceConvertor) {
        this.taskInstanceConvertor = taskInstanceConvertor;
    }

    public CustomTokenDTO toCustomTokenDTO(CustomToken token) {
        CustomTokenDTO dto = new CustomTokenDTO();
        this.setDTOTokenId(token, dto);
        dto.setParentTokenId(token.getParentTokenIdForSubprocess());
        this.convertCommonDTOFields(token, dto);
        return dto;
    }

    private void setDTOTokenId(CustomToken token, CustomTokenDTO dto) {
        long tokenId = token.getId();
        Assert.isTrue((!token.isNew() ? 1 : 0) != 0, (String)"No id assigned for current CustomToken!");
        dto.setTokenId(tokenId);
    }

    public CustomTokenDTO toChildCustomTokenDTO(CustomToken token) {
        CustomTokenDTO dto = new CustomTokenDTO();
        this.setDTOTokenId(token, dto);
        dto.setParentTokenId(token.getParentTokenIdForChild());
        this.convertCommonDTOFields(token, dto);
        return dto;
    }

    private void convertCommonDTOFields(CustomToken token, CustomTokenDTO dto) {
        if (!token.isNew()) {
            dto.setTokenId(token.getId());
        }
        dto.setCompletion(token.getCompletion());
        dto.setProcessId(token.getProcessInstance().getId());
        dto.setTokenName(token.getName());
        dto.setCurrentNodeName(token.getNode().getName());
        dto.setVars(this.getJsonVariablesFromCustomToken(token));
        dto.setOperationalStatus(token.getStatus());
        dto.setAdminStatus(token.getRequestedStatus());
        dto.setComments(this.convertComments(token.getComments()));
        dto.setStartTime(token.getStart());
        dto.setEndTime(token.getEnd());
        dto.setNodeEnter(token.getNodeEnter());
        List<TaskInstanceDTO> taskInstanceDTOs = this.taskInstanceConvertor.toManualTaskInstancesDTO(token);
        dto.setTaskInstances(taskInstanceDTOs);
    }

    public String convertComments(List<Comment> comments) {
        if (CollectionUtils.isEmpty(comments)) {
            return null;
        }
        List simpleComments = Lists.transform(comments, (Function)new Function<Comment, SimpleComment>(){

            public SimpleComment apply(Comment comment) {
                SimpleComment simpleComment = new SimpleComment();
                simpleComment.setCommentType(comment.getActorId());
                simpleComment.setTime(comment.getTime());
                simpleComment.setMessage(comment.getMessage());
                return simpleComment;
            }
        });
        String jsonComments = null;
        try {
            jsonComments = new ObjectMapper().writeValueAsString((Object)simpleComments);
        }
        catch (IOException e) {
            this.logger.error((Object)"errors in convert CustomToken Comments to Json: ", (Throwable)e);
        }
        return jsonComments;
    }

    public List<Comment> convertComments(String jsonComments) {
        if (StringUtils.isBlank((String)jsonComments)) {
            return Collections.emptyList();
        }
        List simpleComments = (List)JsonObjectMapper.toList((String)jsonComments, SimpleComment.class);
        List comments = Lists.transform((List)simpleComments, (Function)new Function<SimpleComment, Comment>(){

            public Comment apply(SimpleComment simpleComment) {
                Comment comment = new Comment(simpleComment.getCommentType(), simpleComment.getMessage());
                Reflection.reflectSetProtectedFieldValue((Object)simpleComment.getTime(), (Object)comment, (String)"time");
                return comment;
            }
        });
        return comments;
    }

    public String getJsonVariablesFromCustomToken(CustomToken token) {
        TokenVariableMap tokenVariableMap = this.getTokenVariableMap(token);
        if (tokenVariableMap == null) {
            return "";
        }
        return this.getJsonVariablesFromVariableInstanceMap(tokenVariableMap);
    }

    private String getJsonVariablesFromVariableInstanceMap(TokenVariableMap tokenVariableMap) {
        Map variableInstanceMap = tokenVariableMap.getVariableInstances();
        Collection<VariableInstance> variableInstances = variableInstanceMap.values();
        return this.convertVariableInstanceToJsonString(variableInstances);
    }

    private TokenVariableMap getTokenVariableMap(CustomToken token) {
        WorkflowProcess processInstance = token.getProcessInstance();
        ContextInstance contextInstance = processInstance.getContextInstance();
        return contextInstance.getTokenVariableMap((Token)token);
    }

    public String convertVariableInstanceToJsonString(Collection<VariableInstance> variableInstances) {
        if (CollectionUtils.isEmpty(variableInstances)) {
            return "";
        }
        LinkedHashMap<String, Map<String, Object>> convertedVars = new LinkedHashMap<String, Map<String, Object>>();
        for (VariableInstance var : variableInstances) {
            String varName = var.getName();
            Map<String, Object> typeAndValue = this.getVarTypeAndValue(var);
            if (CollectionUtils.isEmpty(typeAndValue)) continue;
            convertedVars.put(varName, typeAndValue);
        }
        return JsonObjectMapper.toJsonString(convertedVars);
    }

    private Map<String, Object> getVarTypeAndValue(VariableInstance variableInstance) {
        Datatype type = this.decideValueType(variableInstance);
        Object value = variableInstance.getValue();
        HashMap<String, Object> typeAndValue = new HashMap<String, Object>();
        typeAndValue.put(VARIABLE_TYPE, type);
        typeAndValue.put(VARIABLE_VALUE, value);
        return typeAndValue;
    }

    private Datatype decideValueType(VariableInstance variableInstance) {
        CustomToken token = (CustomToken)variableInstance.getToken();
        WorkflowTemplate template = token.getProcessInstance().getProcessDefinition();
        Collection startTaskVariables = template.getStartTaskVariables();
        for (TaskVariable taskVariable : startTaskVariables) {
            String variableName = taskVariable.getVariableName();
            if (!variableName.equals(variableInstance.getName())) continue;
            return taskVariable.getDatatype();
        }
        return Datatype.STRING;
    }

    public void refillVariableInstance(WorkflowProcess process, CustomTokenDTO customTokenDto) {
        Map<String, Object> convertedMapVars = this.convertVarsJsonToMap(customTokenDto);
        TokenVariableMap tokenVariableMap = this.getTokenVariableMap(process);
        this.refillTokenVariableMap(process, convertedMapVars, tokenVariableMap);
    }

    private void refillTokenVariableMap(WorkflowProcess process, Map<String, Object> convertedMapVars, TokenVariableMap tokenVariableMap) {
        CustomToken rootToken = process.getRootToken();
        for (Map.Entry<String, Object> entry : convertedMapVars.entrySet()) {
            VariableInstance variableInstance = this.getVariableInstance(entry, rootToken);
            if (variableInstance == null) continue;
            tokenVariableMap.addVariableInstance(variableInstance);
        }
    }

    private TokenVariableMap getTokenVariableMap(WorkflowProcess process) {
        CustomToken rootToken = process.getRootToken();
        ContextInstance contextInstance = process.getContextInstance();
        TokenVariableMap tokenVariableMap = contextInstance.getOrCreateTokenVariableMap((Token)rootToken);
        return tokenVariableMap;
    }

    private Map<String, Object> convertVarsJsonToMap(CustomTokenDTO customTokenDto) {
        String jsonTypeVar = customTokenDto.getVars();
        return JsonObjectMapper.toMap((String)jsonTypeVar);
    }

    private VariableInstance getVariableInstance(Map.Entry<String, Object> entry, CustomToken customToken) {
        Map variableMap = (Map)entry.getValue();
        String variableName = entry.getKey();
        String variableType = (String)variableMap.get(VARIABLE_TYPE);
        Object variableValue = variableMap.get(VARIABLE_VALUE);
        try {
            if (variableValue != null) {
                variableValue = DatatypeConverter.convert(variableValue, (Datatype)Datatype.valueOf((String)variableType));
            }
            return VariableInstance.create((Token)customToken, (String)variableName, variableValue);
        }
        catch (TypeConversionException e) {
            this.logger.warn((Object)("Failed to convert variable: " + variableName), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to create variable: " + variableName), (Throwable)e);
        }
        return null;
    }

    public void refillProcess(WorkflowProcess process, CustomTokenDTO customTokenDto) {
        Assert.notNull((Object)customTokenDto, (String)"CustomTokenDTO cannot be null");
        Assert.notNull((Object)process, (String)"WorkflowProcess cannot be null");
        process.setStatus(customTokenDto.getOperationalStatus());
        process.setRequestedStatus(customTokenDto.getAdminStatus());
        this.refillVariableInstance(process, customTokenDto);
    }

    public Node findCurrentNode(WorkflowTemplate template, String nodeName) {
        CurrentNodeVisitor visitor = new CurrentNodeVisitor(nodeName);
        template.greedyBreadthFirstTraversal((NodeVisitor)visitor);
        return visitor.getCurrentNode();
    }

    public void refillCustomToken(CustomToken customToken, CustomTokenDTO customTokenDto) {
        customToken.setCompletion(customTokenDto.getCompletion());
        customToken.setId(customTokenDto.getTokenId());
        customToken.setStatus(customTokenDto.getOperationalStatus());
        customToken.setRequestedStatus(customTokenDto.getAdminStatus());
        customToken.setStart(customTokenDto.getStartTime());
        customToken.setEnd(customTokenDto.getEndTime());
        customToken.setNodeEnter(customTokenDto.getNodeEnter());
        WorkflowTemplate template = customToken.getProcessInstance().getProcessDefinition();
        customToken.setNode(this.findCurrentNode(template, customTokenDto.getCurrentNodeName()));
        this.taskInstanceConvertor.rebuildManualTasks(customToken, customTokenDto.getTaskInstances());
        this.refillComment(customTokenDto, customToken);
    }

    private void refillComment(CustomTokenDTO customTokenDto, CustomToken customToken) {
        List<Comment> comments = this.convertComments(customTokenDto.getComments());
        for (Comment comment : comments) {
            customToken.addComment(comment);
        }
    }

    public List<CustomToken> convertChildTokens(List<CustomTokenDTO> children, CustomToken rootToken) {
        ArrayList<CustomToken> childTokens = new ArrayList<CustomToken>();
        for (CustomTokenDTO childDto : children) {
            CustomToken childToken = new CustomToken(rootToken, childDto.getTokenName(), childDto.getOperationalStatus(), childDto.getAdminStatus());
            this.refillCustomToken(childToken, childDto);
            childTokens.add(childToken);
        }
        return childTokens;
    }

    public Object getValueByDataType(Map<String, Object> valueMap) {
        String variableType = (String)valueMap.get(VARIABLE_TYPE);
        Object variableValue = valueMap.get(VARIABLE_VALUE);
        if (variableValue == null) {
            return null;
        }
        try {
            return DatatypeConverter.convert((Object)variableValue, (Datatype)Datatype.valueOf((String)variableType));
        }
        catch (TypeConversionException e) {
            this.logger.warn((Object)("Failed to convert variable: " + variableValue), (Throwable)e);
            return null;
        }
    }
}

