/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import com.tandbergtv.workflow.core.entity.TaskInstanceDTO;
import com.tandbergtv.workflow.core.entity.WorkflowProcessDTO;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.HibernateTemplate;
import com.tandbergtv.workflow.core.util.SessionUtils;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.internal.CreateIdExistedException;
import com.tandbergtv.workflow.driver.internal.CustomTokenConvertor;
import com.tandbergtv.workflow.driver.internal.CustomTokenDTOService;
import com.tandbergtv.workflow.driver.internal.ISequenceIdGenerator;
import com.tandbergtv.workflow.driver.internal.TaskInstanceConvertor;
import com.tandbergtv.workflow.driver.internal.TaskInstanceDTOService;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessConvertor;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessDTOService;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.search.event.ProcessGUIPartialUpdateEvent;
import com.tandbergtv.workflow.driver.search.event.ProcessPersistEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ProcessPersistenceService
implements IPersistenceService {
    private static final Logger LOGGER = Logger.getLogger(ProcessPersistenceService.class);
    public static final String SERVICE_NAME = "Process Persistence Service";
    private WorkflowProcessDTOService processDtoService;
    private TaskInstanceDTOService taskInstanceDTOService;
    private CustomTokenDTOService customTokenDtoService;
    private WorkflowProcessConvertor processConvertor;
    private CustomTokenConvertor customTokenConvertor;
    private WorkflowProcessCache processCache;
    private IClusterService clusterService;
    private IMediator mediator;
    private TaskInstanceConvertor taskInstanceConvertor;
    private SessionFactory sessionFactory;
    private ISequenceIdGenerator tokenIdGenerator;
    private ISequenceIdGenerator processIdGenerator;
    private ISequenceIdGenerator taskInstanceIdGenerator;

    public ProcessPersistenceService(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public Serializable create(WorkflowProcess process) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (process.isNew()) {
            this.assignProcessId(process);
        }
        if (process.getRootToken().isNew()) {
            this.assignTokenId(process.getRootToken());
        }
        WorkflowProcessDTO lightProcessDto = this.processConvertor.toLightProcessDTO(process);
        Session session = this.sessionFactory.getCurrentSession();
        Transaction t = null;
        try {
            t = session.beginTransaction();
            this.customTokenDtoService.create(lightProcessDto.getRootToken());
            this.processDtoService.create(lightProcessDto);
            this.updateSuperProcessToken(process);
            t.commit();
            this.lifecycleTraceLog(process);
        }
        catch (Exception e) {
            this.rollback(t);
            String errorMsg = "Failed to save the process DTO Objects[" + lightProcessDto.toString() + "]";
            if (this.causedByDuplicatedCreateID(process, e)) {
                throw new CreateIdExistedException(process.getCreateId(), errorMsg, e);
            }
            LOGGER.error((Object)(errorMsg + " error:" + ExceptionUtils.getRootCause((Throwable)e)));
            throw new DriverRuntimeException(errorMsg, e);
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
        LOGGER.debug((Object)("created and saved Process DTO Objects to database: " + lightProcessDto.toString()));
        this.cacheProcess(process);
        this.sendUpdateEvent(process);
        stopwatch.stop();
        LOGGER.debug((Object)("Created the Process: " + process.toString() + " in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms."));
        return Long.valueOf(process.getId());
    }

    private void lifecycleTraceLog(WorkflowProcess process) {
        CustomToken token = process.getRootToken();
        WorkflowTemplate template = process.getProcessDefinition();
        if (process.getSuperProcessToken() != null) {
            LOGGER.info((Object)("[Process] " + token + ", template " + template.getFullName() + ", parent " + process.getSuperProcessToken()));
        } else {
            LOGGER.info((Object)("[Process] " + token + ", template " + template.getFullName()));
        }
    }

    private void rollback(Transaction t) {
        if (t != null && !t.wasCommitted()) {
            t.rollback();
        }
    }

    private boolean causedByDuplicatedCreateID(WorkflowProcess process, Exception e) {
        if (e instanceof ConstraintViolationException) {
            try {
                return this.processDtoService.createIdExists(process.getCreateId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void updateSuperProcessToken(WorkflowProcess process) {
        CustomToken superProcessToken = process.getSuperProcessToken();
        if (superProcessToken != null) {
            this.customTokenDtoService.save(this.customTokenConvertor.toChildCustomTokenDTO(superProcessToken));
        }
    }

    private void cacheProcess(WorkflowProcess process) {
        WorkflowTemplate template = process.getProcessDefinition();
        boolean l2CacheOnlyForWhenNonOwner = !this.getClusterService().isOwner((Object)process.getId());
        this.processCache.cache(process.getId(), process, l2CacheOnlyForWhenNonOwner);
        LOGGER.debug((Object)("Cache Process: " + process.toString() + " for template : " + template.getFullName()));
        this.cacheParentProcess(process);
    }

    private void cacheParentProcess(WorkflowProcess process) {
        if (process.getSuperProcessToken() == null) {
            return;
        }
        WorkflowProcess parent = process.getSuperProcessToken().getProcessInstance();
        WorkflowTemplate template = parent.getProcessDefinition();
        this.processCache.cache(parent.getId(), parent);
        LOGGER.debug((Object)("Cached parent process: " + parent.toString() + ", template " + template.getFullName()));
    }

    @Override
    public WorkflowProcess get(Serializable id) {
        Assert.isInstanceOf(Long.class, (Object)id, (String)"Process ID should be long type.");
        WorkflowProcess process = this.processCache.get(id);
        return process != null ? process : this.retrieveWholeProcess((Long)id);
    }

    private WorkflowProcess fetch(WorkflowProcessDTO processDto) {
        Assert.notNull((Object)processDto, (String)"WorkflowProcessDTO cannot be null");
        WorkflowProcess process = this.processCache.get(Long.valueOf(processDto.getId()));
        return process != null ? process : this.retrieveWholeProcess(processDto);
    }

    private WorkflowProcess retrieveWholeProcess(Long id) {
        WorkflowProcess process;
        boolean isFatherDto;
        WorkflowProcessDTO processDto = this.fetchTopProcessDTO(id);
        if (processDto == null) {
            return null;
        }
        boolean bl = isFatherDto = id.longValue() != processDto.getId() && !processDto.isSubprocess();
        if (isFatherDto) {
            WorkflowProcess topProcess = this.processConvertor.toProcessObject(processDto);
            process = this.filterSubProcess(id, topProcess);
        } else {
            process = this.processConvertor.toProcessObject(processDto);
        }
        return process;
    }

    private WorkflowProcess retrieveWholeProcess(WorkflowProcessDTO processDto) {
        this.fillData(processDto);
        return this.processConvertor.toProcessObject(processDto);
    }

    private WorkflowProcess filterSubProcess(long subProcessId, WorkflowProcess topProcess) {
        WorkflowProcess process = topProcess.filterSubProcess(Long.valueOf(subProcessId));
        if (process == null) {
            process = this.fetchSubProcess(subProcessId, topProcess);
        }
        return process;
    }

    private WorkflowProcess fetchSubProcess(long id, WorkflowProcess topProcess) {
        WorkflowProcessDTO processDto = this.processDtoService.get(id);
        this.fillData(processDto);
        WorkflowProcess process = this.processConvertor.toProcessObject(processDto);
        if (topProcess != null) {
            process.setSuperProcessToken((Token)topProcess.findToken(processDto.getParentTokenId()));
        }
        return process;
    }

    private WorkflowProcessDTO fetchTopProcessDTO(long id) {
        WorkflowProcessDTO processDto = this.getTopLevelProcess(id);
        this.fillData(processDto);
        return processDto;
    }

    private WorkflowProcessDTO getTopLevelProcess(long id) {
        return (WorkflowProcessDTO)Iterables.getFirst(this.processDtoService.getAllInTopLevel(Lists.newArrayList((Object[])new Serializable[]{Long.valueOf(id)})), null);
    }

    private void fillData(WorkflowProcessDTO processDto) {
        if (processDto == null) {
            return;
        }
        CustomTokenDTO rootTokenDto = this.customTokenDtoService.getToken(processDto.getRootTokenId());
        rootTokenDto.setTaskInstances(this.fetchTaskInstances(rootTokenDto));
        processDto.setRootToken(rootTokenDto);
        List<CustomTokenDTO> childTokenDTOs = this.fetchChildTokenDTOs(processDto.getId(), rootTokenDto.getTokenId());
        processDto.setChildrenTokens(childTokenDTOs);
        ArrayList<Long> rootTokenIdAndChildTokenIds = new ArrayList<Long>();
        rootTokenIdAndChildTokenIds.add(rootTokenDto.getTokenId());
        for (CustomTokenDTO customTokenDTO : childTokenDTOs) {
            rootTokenIdAndChildTokenIds.add(customTokenDTO.getTokenId());
        }
        processDto.setSubProcesses(this.fetchSubProcessDTO(processDto.getId(), rootTokenIdAndChildTokenIds));
    }

    private List<TaskInstanceDTO> fetchTaskInstances(CustomTokenDTO rootToken) {
        return this.taskInstanceDTOService.getTaskInstances(rootToken.getTokenId());
    }

    private List<CustomTokenDTO> fetchChildTokenDTOs(long processId, long tokenId) {
        List<CustomTokenDTO> childTokens = this.customTokenDtoService.getChildTokens(tokenId, processId);
        for (CustomTokenDTO customTokenDTO : childTokens) {
            customTokenDTO.setTaskInstances(this.fetchTaskInstances(customTokenDTO));
        }
        return childTokens;
    }

    List<WorkflowProcessDTO> fetchSubProcessDTO(long parentProcessId, List<Long> rootTokenIdAndChildTokenIds) {
        ArrayList<WorkflowProcessDTO> subProcessDtos = new ArrayList<WorkflowProcessDTO>();
        for (Long parentTokenId : rootTokenIdAndChildTokenIds) {
            WorkflowProcessDTO latestSubProcess = this.processDtoService.getLatestSubProcess(parentProcessId, parentTokenId);
            if (latestSubProcess == null) continue;
            subProcessDtos.add(latestSubProcess);
        }
        if (CollectionUtils.isEmpty(subProcessDtos)) {
            return Collections.emptyList();
        }
        for (WorkflowProcessDTO subProcessDto : subProcessDtos) {
            List<CustomTokenDTO> subProcessChildTokenDTOs = this.fetchChildTokenDTOs(subProcessDto.getId(), subProcessDto.getRootTokenId());
            CustomTokenDTO rootTokenDto = this.customTokenDtoService.getToken(subProcessDto.getRootTokenId());
            rootTokenDto.setTaskInstances(this.fetchTaskInstances(rootTokenDto));
            subProcessDto.setRootToken(rootTokenDto);
            subProcessDto.setChildrenTokens(subProcessChildTokenDTOs);
        }
        return subProcessDtos;
    }

    @Override
    public List<WorkflowProcess> getAll(List<Serializable> ids) {
        List<WorkflowProcessDTO> topProcessList = this.processDtoService.getAllInTopLevel(ids);
        if (CollectionUtils.isEmpty(topProcessList)) {
            return Collections.emptyList();
        }
        HashSet<Long> uniqueIdSet = this.toUniqueIdSet(ids);
        ArrayList processes = Lists.newArrayList();
        for (WorkflowProcessDTO workflowProcessDTO : topProcessList) {
            WorkflowProcess process = this.fetch(workflowProcessDTO);
            if (process == null) {
                LOGGER.warn((Object)("Cannot load Process in database with id " + workflowProcessDTO.getId()));
                continue;
            }
            processes.add(process);
            if (!process.hasSubProcessInstances()) continue;
            this.addSubProcessToResult(uniqueIdSet, processes, process.getSubProcessInstances());
        }
        this.handleTopLevelProcessNotInInput(ids, processes);
        return processes;
    }

    private HashSet<Long> toUniqueIdSet(List<Serializable> ids) {
        HashSet uniqueIdSet = Sets.newHashSet();
        for (Serializable id : ids) {
            if (id == null) continue;
            uniqueIdSet.add(HibernateTemplate.toLong((Object)id));
        }
        return uniqueIdSet;
    }

    private void handleTopLevelProcessNotInInput(List<Serializable> ids, List<WorkflowProcess> processes) {
        ArrayList extraProcesses = Lists.newArrayList();
        for (WorkflowProcess process : processes) {
            if (ids.contains(process.getId())) continue;
            extraProcesses.add(process);
        }
        for (WorkflowProcess extra : extraProcesses) {
            this.processCache.cache(extra.getId(), extra);
        }
        processes.removeAll(extraProcesses);
    }

    private void addSubProcessToResult(HashSet<Long> idSet, List<WorkflowProcess> processes, Collection<WorkflowProcess> subs) {
        for (WorkflowProcess subProcess : subs) {
            if (!idSet.contains(subProcess.getId())) continue;
            processes.add(subProcess);
        }
    }

    @Override
    public CustomToken getToken(Serializable id) {
        Assert.isInstanceOf(Long.class, (Object)id, (String)"Token ID should be long type.");
        CustomTokenDTO customTokenDTO = this.customTokenDtoService.getToken((Long)id);
        if (customTokenDTO == null) {
            return null;
        }
        WorkflowProcess process = this.get(Long.valueOf(customTokenDTO.getProcessId()));
        return process.findToken(((Long)id).longValue());
    }

    @Override
    public void persist(WorkflowProcess process) {
        process.lock();
        if (process.isNew()) {
            this.assignProcessId(process);
        }
        try {
            this.doSave(process);
        }
        catch (Exception exception) {
            LOGGER.error((Object)("something wrong when persisting WorkflowProcess: " + process.toString()), (Throwable)exception);
        }
        finally {
            process.unlock();
            if (process.hasEnded() || !process.isActive()) {
                this.processCache.uncache(process.getId());
            } else {
                this.processCache.cache(process.getId(), process);
            }
        }
    }

    @Override
    public void save(CustomToken token) {
        this.save(token.getProcessInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WorkflowProcess process) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        process.lock();
        if (process.isNew()) {
            this.assignProcessId(process);
        }
        try {
            this.processCache.cache(process.getId(), process);
            if (!ProcessPersistenceService.isTrace(process)) {
                return;
            }
            this.doSave(process);
            stopwatch.stop();
            LOGGER.debug((Object)("Save a  Process " + process.toString() + " into DB in " + Watch.cost((Stopwatch)stopwatch)));
        }
        catch (Exception exception) {
            LOGGER.error((Object)("something wrong when saving WorkflowProcess: " + process.toString()), (Throwable)exception);
        }
        finally {
            process.unlock();
        }
    }

    private void doSave(WorkflowProcess process) {
        this.doSave(process, process.getSubProcessInstances());
    }

    private void doSave(WorkflowProcess process, Collection<WorkflowProcess> subProcessList) {
        Session session = this.sessionFactory.getCurrentSession();
        Transaction t = null;
        try {
            t = session.beginTransaction();
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.createChildTokenIfAny(process);
            this.createManualTaskInstanceIfAny(process);
            WorkflowProcessDTO processDTO = this.processConvertor.toProcessDTO(process, subProcessList);
            this.customTokenDtoService.save(processDTO.getRootToken());
            this.processDtoService.save(processDTO);
            this.saveChildTokenDTO(processDTO);
            this.saveSubProcessDTO(processDTO.getSubProcesses());
            this.saveManualTask(processDTO);
            stopwatch.stop();
            t.commit();
            LOGGER.debug((Object)("Save Process [" + process.toString() + "] to database in  " + Watch.cost((Stopwatch)stopwatch)));
        }
        catch (Exception e) {
            this.rollback(t);
            LOGGER.error((Object)("Failed to save the process " + process), (Throwable)e);
            throw new DriverRuntimeException("Failed to save the process", e);
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
        this.sendUpdateEvent(process);
    }

    public void update(WorkflowProcess process, ProcessPriority priority, String processNotesText) {
        Transaction t = null;
        process.lock();
        long processId = process.getId();
        Session session = this.sessionFactory.getCurrentSession();
        try {
            t = session.beginTransaction();
            int priorityNo = priority != null ? priority.ordinal() : -1;
            String noteTxt = null;
            if (StringUtils.isNotBlank((String)processNotesText)) {
                process.appendNotes(processNotesText);
                noteTxt = process.getNote().getJsonFormattedNotes();
            }
            this.processDtoService.update(processId, priorityNo, noteTxt);
            t.commit();
        }
        catch (Exception e) {
            this.rollback(t);
            LOGGER.error((Object)("Failed to update the process " + process), (Throwable)e);
            throw new DriverRuntimeException("Failed to update the process", e);
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
            process.unlock();
        }
        if (this.processCache.get(Long.valueOf(processId)) != null) {
            this.updateCache(processId, process);
        }
        this.sendParitalUpdateEvent(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProcess(WorkflowProcess process, List<WorkflowProcess> subProcessList) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        process.lock();
        try {
            this.doSave(process, subProcessList);
            LOGGER.debug((Object)("Save a  Process " + process.toString() + " into DB in " + Watch.cost((Stopwatch)stopwatch)));
        }
        finally {
            process.unlock();
        }
    }

    public boolean idExists(Long id) {
        return this.processDtoService.workOrderNoExists(id);
    }

    private void createManualTaskInstanceIfAny(WorkflowProcess process) {
        TaskInstance task = this.taskInstanceConvertor.findNewManualTaskInstance(process);
        if (task != null) {
            this.assignTaskId(task);
            TaskInstanceDTO instanceDto = this.taskInstanceConvertor.toTaskInstanceDto(task);
            this.taskInstanceDTOService.createTaskInstance(instanceDto);
        }
    }

    void saveManualTask(WorkflowProcessDTO processDto) {
        this.saveTaskInstances(processDto.getRootToken().getTaskInstances());
        for (CustomTokenDTO tokenDTO : processDto.getChildrenTokens()) {
            this.saveTaskInstances(tokenDTO.getTaskInstances());
        }
    }

    private void saveTaskInstances(List<TaskInstanceDTO> dtos) {
        for (TaskInstanceDTO instanceDTO : dtos) {
            if (!instanceDTO.hasEnded()) continue;
            this.taskInstanceDTOService.endTaskInstance(instanceDTO.getTaskId(), instanceDTO.getEndTime());
        }
    }

    void createChildTokenIfAny(WorkflowProcess process) {
        if (CollectionUtils.isEmpty((Collection)process.getChildTokens())) {
            return;
        }
        for (CustomToken child : process.getChildTokens()) {
            if (!child.isNew()) continue;
            this.assignTokenId(child);
            this.assignTaskId(child);
            CustomTokenDTO childCustomTokenDTO = this.customTokenConvertor.toChildCustomTokenDTO(child);
            this.customTokenDtoService.create(childCustomTokenDTO);
            LOGGER.debug((Object)("Created and saved child token to database: " + child.toString()));
        }
    }

    private void assignTaskId(CustomToken token) {
        List<TaskInstance> instances = this.taskInstanceConvertor.findManualTaskInstances(token);
        for (TaskInstance taskInstance : instances) {
            this.assignTaskId(taskInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignTaskId(TaskInstance taskInstance) {
        if (taskInstance != null) {
            TaskInstance taskInstance2 = taskInstance;
            synchronized (taskInstance2) {
                if (taskInstance.getId() <= 0L) {
                    taskInstance.setId(this.taskInstanceIdGenerator.queryId());
                    LOGGER.debug((Object)("TaskInstance ID generated: " + taskInstance.getId()));
                }
            }
        }
    }

    private void assignTokenId(CustomToken token) {
        if (token.isNew()) {
            long tokenId = this.tokenIdGenerator.queryId();
            token.setId(tokenId);
            LOGGER.debug((Object)("CustomToken ID generated: " + tokenId));
        }
    }

    private void assignProcessId(WorkflowProcess process) {
        if (process.isNew()) {
            long processId = this.processIdGenerator.queryId();
            process.setId(processId);
            LOGGER.debug((Object)("Workflow Process ID generated: " + processId));
        }
    }

    void saveChildTokenDTO(WorkflowProcessDTO processDTO) {
        if (CollectionUtils.isEmpty((Collection)processDTO.getChildrenTokens())) {
            return;
        }
        for (CustomTokenDTO child : processDTO.getChildrenTokens()) {
            this.customTokenDtoService.save(child);
            LOGGER.debug((Object)("Saved child token to database: " + child.toString()));
        }
    }

    private void updateCache(long processId, WorkflowProcess process) {
        WorkflowProcess cached = this.processCache.get(Long.valueOf(processId));
        if (cached == null) {
            return;
        }
        cached.setPriority(process.getPriority());
        if (process.getNote() != null) {
            cached.setNote(process.getNote());
        }
        this.processCache.add((Serializable)Long.valueOf(processId), cached);
    }

    private void sendUpdateEvent(WorkflowProcess process) {
        this.getMediator().sendAsync((WorkflowEvent)new ProcessPersistEvent(process, false));
    }

    private void sendParitalUpdateEvent(WorkflowProcess process) {
        this.getMediator().sendAsync((WorkflowEvent)new ProcessGUIPartialUpdateEvent(process));
    }

    void saveSubProcessDTO(Collection<WorkflowProcessDTO> subProcesses) {
        if (CollectionUtils.isEmpty(subProcesses)) {
            return;
        }
        for (WorkflowProcessDTO subProcess : subProcesses) {
            this.customTokenDtoService.save(subProcess.getRootToken());
            this.processDtoService.save(subProcess);
        }
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    private IMediator getMediator() {
        if (this.mediator == null) {
            this.mediator = DefaultMediator.getInstance();
        }
        return this.mediator;
    }

    private static boolean isTrace(WorkflowProcess process) {
        return process.getLogLevel() == LogLevel.ALL;
    }

    public void setProcessDtoService(WorkflowProcessDTOService processDtoService) {
        this.processDtoService = processDtoService;
    }

    public void setTaskInstanceDTOService(TaskInstanceDTOService taskInstanceDTOService) {
        this.taskInstanceDTOService = taskInstanceDTOService;
    }

    public void setCustomTokenDtoService(CustomTokenDTOService customTokenDtoService) {
        this.customTokenDtoService = customTokenDtoService;
    }

    public void setProcessConvertor(WorkflowProcessConvertor processConvertor) {
        this.processConvertor = processConvertor;
    }

    public void setCustomTokenConvertor(CustomTokenConvertor customTokenConvertor) {
        this.customTokenConvertor = customTokenConvertor;
    }

    public void setProcessCache(WorkflowProcessCache processCache) {
        this.processCache = processCache;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setMediator(IMediator mediator) {
        this.mediator = mediator;
    }

    public void setTaskInstanceConvertor(TaskInstanceConvertor taskInstanceConvertor) {
        this.taskInstanceConvertor = taskInstanceConvertor;
    }

    public void setTokenIdGenerator(ISequenceIdGenerator idGenerator) {
        this.tokenIdGenerator = idGenerator;
    }

    public void setTaskInstanceIdGenerator(ISequenceIdGenerator taskInstanceIdGenerator) {
        this.taskInstanceIdGenerator = taskInstanceIdGenerator;
    }

    public void setProcessIdGenerator(ISequenceIdGenerator idGenerator) {
        this.processIdGenerator = idGenerator;
    }
}

