/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.internal.monitor.InvalidWorkOrderCleaner;
import com.tandbergtv.workflow.process.ratelimiter.IActiveWorkOrderMonitor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ActiveWorkOrderMonitor
implements IActiveWorkOrderMonitor {
    private static final Logger LOGGER = Logger.getLogger(ActiveWorkOrderMonitor.class);
    private List<WorkflowProcessEventType> stopTypes = Lists.newArrayList((Object[])new WorkflowProcessEventType[]{WorkflowProcessEventType.STOPPED, WorkflowProcessEventType.FAILED, WorkflowProcessEventType.PAUSED, WorkflowProcessEventType.CANCELLED, WorkflowProcessEventType.DELETED});
    private List<WorkflowProcessEventType> startTypes = Lists.newArrayList((Object[])new WorkflowProcessEventType[]{WorkflowProcessEventType.CREATED, WorkflowProcessEventType.STARTED, WorkflowProcessEventType.QUEUED});
    private List<WorkflowProcessEventType> ignoreTypes = Lists.newArrayList((Object[])new WorkflowProcessEventType[]{WorkflowProcessEventType.RESUMED, WorkflowProcessEventType.ACQUIRED, WorkflowProcessEventType.CRASHED, WorkflowProcessEventType.RELEASED});
    private Cache<String, Long> activeWOShortTimeCache;
    private Cache<String, Long> activeWOCache;
    private InvalidWorkOrderCleaner cacheCleaner;
    private Lock lock = new ReentrantLock();

    public ActiveWorkOrderMonitor() {
        this.activeWOShortTimeCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
        this.activeWOCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(24L, TimeUnit.HOURS).build();
        this.cacheCleaner = new InvalidWorkOrderCleaner(this);
    }

    public void setCacheCleaner(InvalidWorkOrderCleaner cacheCleaner) {
        this.cacheCleaner = cacheCleaner;
        cacheCleaner.setActiveWorkOrderMonitor(this);
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        Object source = event.getSource();
        if (source == this || !(event instanceof WorkflowProcessEvent)) {
            return;
        }
        WorkflowProcessEvent e = (WorkflowProcessEvent)event;
        CustomToken token = (CustomToken)e.getToken();
        if (token.isSubProcess() || !token.isRoot() || this.ignoreTypes.contains(e.getType())) {
            return;
        }
        LOGGER.debug((Object)("ActiveMonitor: receive a status change event:" + token + ", eventType:" + e.getType()));
        WorkflowProcess process = token.getProcessInstance();
        String createId = StringUtils.trim((String)process.getCreateId());
        if (StringUtils.isBlank((String)createId)) {
            LOGGER.warn((Object)("Cannot find the created id for process:" + process));
        }
        if (this.stopTypes.contains(e.getType())) {
            this.removeActiveWO(createId);
            LOGGER.debug((Object)("Received a end event, clean the monitor by createId :" + createId + " status:" + process.getStatus()));
        } else if (this.startTypes.contains(e.getType())) {
            LOGGER.debug((Object)("Received a start event, upgrade the counter to long time monitor by createId :" + createId + " status:" + process.getStatus()));
            this.upgradeCounterToFormalCache(createId);
        }
    }

    public boolean isInMonitor(String createId) {
        this.lock.lock();
        try {
            boolean bl = this.activeWOShortTimeCache.getIfPresent((Object)createId) != null || this.activeWOCache.getIfPresent((Object)createId) != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void upgradeCounterToFormalCache(String createId) {
        if (this.activeWOShortTimeCache.getIfPresent((Object)createId) == null || this.activeWOCache.getIfPresent((Object)createId) != null) {
            return;
        }
        this.lock.lock();
        try {
            LOGGER.debug((Object)("Upgrade a WO with create id[" + createId + "] to Monitor in formal watch"));
            this.activeWOCache.put((Object)createId, (Object)System.currentTimeMillis());
            this.activeWOShortTimeCache.invalidate((Object)createId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addActiveWO(String createId) {
        this.lock.lock();
        try {
            LOGGER.debug((Object)("Add a message [" + createId + "] to Monitor in short time watch"));
            this.activeWOShortTimeCache.put((Object)createId, (Object)System.currentTimeMillis());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeActiveWO(String createId) {
        this.lock.lock();
        try {
            LOGGER.debug((Object)("Remove the  message[" + createId + "] from the Monitor."));
            this.activeWOShortTimeCache.invalidate((Object)createId);
            this.activeWOCache.invalidate((Object)createId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getActiveWOCount() {
        return this.getActiveWOSet().size();
    }

    public List<String> getActiveWOSet() {
        Set ids;
        this.lock.lock();
        try {
            ids = Sets.newConcurrentHashSet();
            ConcurrentMap wos = this.activeWOShortTimeCache.asMap();
            if (wos.size() > 0) {
                ids.addAll(Lists.newArrayList(wos.keySet()));
            }
            if ((wos = this.activeWOCache.asMap()).size() > 0) {
                ids.addAll(Lists.newArrayList(wos.keySet()));
            }
        }
        finally {
            this.lock.unlock();
        }
        return ids.isEmpty() ? Lists.newArrayList() : Lists.newArrayList((Iterable)ids);
    }

    public void start() {
        this.cacheCleaner.start();
        LOGGER.debug((Object)"Active WorkOrder Monitor service started");
    }

    public void stop() {
        this.activeWOCache.invalidateAll();
        this.activeWOShortTimeCache.invalidateAll();
        this.cacheCleaner.stop();
        LOGGER.debug((Object)"Active WorkOrder Monitor service stopped");
    }

    public Map<String, Long> getActiveWoCache() {
        return this.activeWOCache.asMap();
    }
}

