/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.internal.monitor.IMetricUnit;
import com.tandbergtv.workflow.driver.internal.monitor.MetricLogger;
import com.tandbergtv.workflow.driver.internal.monitor.ScheduledMetricLogWriter;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CumulativeStatistics
implements IProcessMonitor,
IProcessCounter,
IMetricUnit {
    private Map<ProcessStatus, AtomicInteger> counters;
    private Map<ProcessStatus, AtomicInteger> countersPerMinute;
    private AtomicInteger restarted = new AtomicInteger(0);
    private double maxCreateRate;
    private double createRate;
    private double createRate0;
    private AtomicInteger created0 = new AtomicInteger(0);
    private double factor;
    private Long period;

    public CumulativeStatistics(double maxCreateRate, double factor, Long period) {
        this.factor = factor;
        this.maxCreateRate = maxCreateRate;
        this.period = period;
        this.counters = new EnumMap<ProcessStatus, AtomicInteger>(ProcessStatus.class);
        this.countersPerMinute = new EnumMap<ProcessStatus, AtomicInteger>(ProcessStatus.class);
        for (ProcessStatus status : ProcessStatus.values()) {
            this.counters.put(status, new AtomicInteger());
        }
        this.countersPerMinute.put(ProcessStatus.COMPLETED, new AtomicInteger());
        this.countersPerMinute.put(ProcessStatus.ERROR, new AtomicInteger());
        this.countersPerMinute.put(ProcessStatus.CANCELLED, new AtomicInteger());
        this.resetCounter();
        ScheduledMetricLogWriter.getInstance().addMetricUnit(this, true);
    }

    public void resetCounter() {
        this.countersPerMinute.clear();
        this.countersPerMinute.put(ProcessStatus.COMPLETED, new AtomicInteger());
        this.countersPerMinute.put(ProcessStatus.ERROR, new AtomicInteger());
        this.countersPerMinute.put(ProcessStatus.CANCELLED, new AtomicInteger());
    }

    @Override
    public int getCancelled() {
        return this.counters.get(ProcessStatus.CANCELLED).get();
    }

    @Override
    public double getCreateRate() {
        return this.createRate;
    }

    @Override
    public int getCreateRatePerMinute() {
        return (int)(this.createRate * 60.0);
    }

    @Override
    public int getCreated() {
        return this.counters.get(ProcessStatus.CREATED).get();
    }

    @Override
    public double getMaxCreateRate() {
        return this.maxCreateRate;
    }

    @Override
    public void setMaxCreateRate(double rate) {
        this.maxCreateRate = rate;
    }

    @Override
    public int getMaxCreateRatePerMinute() {
        return (int)(this.maxCreateRate * 60.0);
    }

    @Override
    public int getPaused() {
        return this.counters.get(ProcessStatus.PAUSED).get();
    }

    @Override
    public int getRestarted() {
        return this.restarted.get();
    }

    @Override
    public int getQueued() {
        return this.counters.get(ProcessStatus.QUEUED).get();
    }

    @Override
    public int getCompleted() {
        return this.counters.get(ProcessStatus.COMPLETED).get();
    }

    @Override
    public int getFailed() {
        return this.counters.get(ProcessStatus.ERROR).get();
    }

    @Override
    public int getBranched() {
        return this.counters.get(ProcessStatus.BRANCHED).get();
    }

    @Override
    public int getRunning() {
        return this.counters.get(ProcessStatus.RUNNING).get();
    }

    @Override
    public void created(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.CREATED);
        }
    }

    @Override
    public void started(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.RUNNING);
        }
    }

    @Override
    public void paused(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.PAUSED);
        }
    }

    @Override
    public void cancelled(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.CANCELLED);
            this.incrementMinuteCounter(ProcessStatus.CANCELLED);
        }
    }

    @Override
    public void resumed(CustomToken token) {
    }

    @Override
    public void enqueued(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.QUEUED);
        }
    }

    @Override
    public void dequeued(CustomToken token) {
    }

    @Override
    public void completed(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.COMPLETED);
            this.incrementMinuteCounter(ProcessStatus.COMPLETED);
        }
    }

    @Override
    public void failed(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.ERROR);
            this.incrementMinuteCounter(ProcessStatus.ERROR);
        }
    }

    @Override
    public void branched(CustomToken token) {
        if (token.isRoot()) {
            this.incrementCounter(ProcessStatus.BRANCHED);
        }
    }

    @Override
    public void restarted() {
        this.restarted.incrementAndGet();
    }

    @Override
    public void deleted(CustomToken token) {
    }

    @Override
    public void recalculateCreateRate() {
        double deltaN = (double)this.getCreated() - this.created0.doubleValue();
        double delta = deltaN * 1000.0 / this.period.doubleValue();
        double rate = this.factor * delta + (1.0 - this.factor) * this.createRate0;
        this.createRate0 = this.createRate = rate > 1.0E-4 ? rate : 0.0;
        this.created0.set(this.getCreated());
    }

    protected void incrementCounter(ProcessStatus status) {
        this.counters.get(status).incrementAndGet();
    }

    protected void incrementMinuteCounter(ProcessStatus status) {
        this.countersPerMinute.get(status).incrementAndGet();
    }

    @Override
    public boolean onlyWriteInMasterNode() {
        return false;
    }

    @Override
    public void write(MetricLogger logWriter) {
        logWriter.writeLog(ProcessStatus.COMPLETED.toString().toLowerCase(), "" + this.countersPerMinute.get(ProcessStatus.COMPLETED));
        logWriter.writeLog(ProcessStatus.ERROR.toString().toLowerCase(), "" + this.countersPerMinute.get(ProcessStatus.ERROR));
        logWriter.writeLog(ProcessStatus.CANCELLED.toString().toLowerCase(), "" + this.countersPerMinute.get(ProcessStatus.CANCELLED));
        this.resetCounter();
    }

    @Override
    public String getMetricName() {
        return "process_status";
    }
}

