/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.process;

import com.google.common.base.Stopwatch;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.internal.CompositeCache;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.process.IProcessLocalCacheSyncPolicy;
import com.tandbergtv.workflow.driver.process.SimpleVariablePrioritySyncPolicy;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCacheWrapper;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCacheWrapperFactory;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class WorkflowProcessCache
extends CompositeCache<WorkflowProcess> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowProcessCache.class);
    public static final String CACHE_NAME = "Process Cache";
    private IProcessLocalCacheSyncPolicy processSyncPolicy;

    public WorkflowProcessCache(String name, int size) {
        super(name, size);
        this.addLocalCacheSyncPolicy(new SimpleVariablePrioritySyncPolicy());
    }

    public void addLocalCacheSyncPolicy(IProcessLocalCacheSyncPolicy processSyncPolicy) {
        this.processSyncPolicy = processSyncPolicy;
    }

    public void start() {
        super.start();
        this.addL2CacheUpdateListener();
    }

    private void updateLocalCache(EntryEvent<Serializable, WorkflowProcess> event) {
        if (!this.isSyncToL1(event)) {
            return;
        }
        try {
            WorkflowProcess l2Entity = this.toProcess((WorkflowProcess)event.getValue());
            long key = l2Entity.getId();
            WorkflowProcess l1Entity = (WorkflowProcess)this.getLocalCache().get((Serializable)Long.valueOf(key));
            if (l1Entity != null) {
                this.processSyncPolicy.sync(l2Entity, l1Entity);
                LOGGER.debug((Object)"Update the L1 object with latest variable info and priority from L2 changed event");
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"Failed to sync up data between L1 and L2", (Throwable)e);
        }
    }

    private boolean isSyncToL1(EntryEvent<Serializable, WorkflowProcess> event) {
        boolean isSync = true;
        if (this.internal(event)) {
            LOGGER.debug((Object)"is a internal event");
            isSync = false;
        }
        if (this.processSyncPolicy == null) {
            LOGGER.debug((Object)"No sync up policy setted, do nothing between L1 and L2");
            isSync = false;
        }
        return isSync;
    }

    protected void addL2CacheUpdateListener() {
        IMap<Serializable, WorkflowProcess> map = this.getL2Cache();
        map.addEntryListener((MapListener)new EntryAddedListener<Serializable, WorkflowProcess>(){

            public void entryAdded(EntryEvent<Serializable, WorkflowProcess> event) {
                LOGGER.debug((Object)("L2 cached is added new Process:" + event.getKey()));
                WorkflowProcessCache.this.updateLocalCache((EntryEvent<Serializable, WorkflowProcess>)event);
            }
        }, true);
        map.addEntryListener((MapListener)new EntryUpdatedListener<Serializable, WorkflowProcess>(){

            public void entryUpdated(EntryEvent<Serializable, WorkflowProcess> event) {
                LOGGER.debug((Object)("L2 cached is updated to new Process:" + event.getKey()));
                WorkflowProcessCache.this.updateLocalCache((EntryEvent<Serializable, WorkflowProcess>)event);
            }
        }, true);
        map.addEntryListener((MapListener)new EntryRemovedListener<Serializable, WorkflowProcess>(){

            public void entryRemoved(EntryEvent<Serializable, WorkflowProcess> event) {
                LOGGER.debug((Object)("L2 cached is removed to new Process:" + event.getKey()));
                WorkflowProcessCache.this.removeLocalCache((EntryEvent<Serializable, WorkflowProcess>)event);
            }
        }, true);
    }

    private void removeLocalCache(EntryEvent<Serializable, WorkflowProcess> event) {
        if (!this.isSyncToL1(event)) {
            return;
        }
        this.cache.remove((Serializable)event.getKey());
    }

    private IMap<Serializable, WorkflowProcess> getL2Cache() {
        return (IMap)this.getMap();
    }

    private void assertArgument(Serializable key, WorkflowProcess entity) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        Assert.notNull((Object)entity, (String)"WorkflowProcess cannot be null");
        Assert.isTrue((boolean)(key instanceof Long), (String)"Key have to be long value");
    }

    public void add(Serializable key, WorkflowProcess entity) {
        this.assertArgument(key, entity);
        this.getLocalCache().add(key, (Object)entity);
        this.addCentralizedCache(entity);
    }

    public void cache(long key, WorkflowProcess entity) {
        this.add((Serializable)Long.valueOf(key), entity);
    }

    public void cache(long id, WorkflowProcess entity, boolean l2CacheOnly) {
        if (l2CacheOnly) {
            this.addCentralizedCache(entity);
        } else {
            this.cache(id, entity);
        }
    }

    public void uncache(long key) {
        this.remove(Long.valueOf(key));
    }

    private void addCentralizedCache(WorkflowProcess entity) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        WorkflowProcessCacheWrapper cachedEntity = this.updateL2Cache(entity);
        CustomToken superProcessToken = entity.getSuperProcessToken();
        if (superProcessToken != null) {
            WorkflowProcess parentProcessInstance = superProcessToken.getProcessInstance();
            this.updateL2Cache(parentProcessInstance);
        }
        LOGGER.debug((Object)("Cache the Process Object" + (Object)((Object)cachedEntity) + " into hazelcast in " + Watch.cost((Stopwatch)stopwatch)));
    }

    private WorkflowProcessCacheWrapper updateL2Cache(WorkflowProcess entity) {
        WorkflowProcessCacheWrapper cachedEntity = this.toProcessWrapper(entity);
        this.set(Long.valueOf(entity.getId()), (Object)cachedEntity);
        return cachedEntity;
    }

    private WorkflowProcessCacheWrapper toProcessWrapper(WorkflowProcess entity) {
        return WorkflowProcessCacheWrapperFactory.create(entity);
    }

    private WorkflowProcess toProcess(WorkflowProcess wrapper) {
        return WorkflowProcessCacheWrapperFactory.create((WorkflowProcessCacheWrapper)wrapper);
    }

    public WorkflowProcess get(Serializable key) {
        Assert.notNull((Object)key, (String)"Work order id cannot be null.");
        Stopwatch stopwatch = Stopwatch.createStarted();
        WorkflowProcess entity = (WorkflowProcess)this.getLocalCache().get(key);
        if (entity == null) {
            entity = this.getFromL2Cache(key);
        }
        LOGGER.debug((Object)("get Process[" + key + "] from cache in " + Watch.cost((Stopwatch)stopwatch)));
        return entity;
    }

    public WorkflowProcess getFromL2Cache(Serializable key) {
        Assert.notNull((Object)key, (String)"Work order id cannot be null.");
        WorkflowProcessCacheWrapper wrapper = (WorkflowProcessCacheWrapper)((Object)this.getL2Cache().get((Object)key));
        if (wrapper == null) {
            LOGGER.debug((Object)("Couldn't get process from L2 Cache on key:" + key));
            return null;
        }
        return this.toProcess(wrapper);
    }

    protected boolean internal(EntryEvent<Serializable, WorkflowProcess> event) {
        return this.getClusterService().getLocalMember().equals(event.getMember());
    }

    public WorkflowProcess getInL1(long key) {
        return (WorkflowProcess)this.getLocalCache().get((Serializable)Long.valueOf(key));
    }

    public boolean isInL1(long id) {
        return this.getLocalCache().getKeys().contains(id);
    }
}

