/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.util.DateFormatter;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class CriteriaBuilder {
    public static void build(Criteria criteria, SearchCriteria searchCriteria) {
        if (searchCriteria.getRecordsCount() > 0) {
            criteria.setMaxResults(searchCriteria.getRecordsCount());
        }
        for (SearchParameterBase parameter : searchCriteria.getSearchList()) {
            if (parameter instanceof SortParameter) {
                CriteriaBuilder.handleSortType(criteria, parameter);
            }
            if (parameter instanceof RangeParameter) {
                CriteriaBuilder.handleRangeType(criteria, parameter);
            }
            if (parameter instanceof ValueParameter) {
                CriteriaBuilder.handleValueType(criteria, parameter);
            }
            if (!(parameter instanceof ListParameter)) continue;
            CriteriaBuilder.handleListType(criteria, parameter);
        }
    }

    private static void handleListType(Criteria criteria, SearchParameterBase parameter) {
        ListParameter valueParameter = (ListParameter)parameter;
        criteria.add(Restrictions.in((String)valueParameter.fieldName, (Collection)valueParameter.getValues()));
    }

    private static void handleValueType(Criteria criteria, SearchParameterBase parameter) {
        ValueParameter valueParameter = (ValueParameter)parameter;
        if (valueParameter.getOperator() == SearchOperator.EQUAL) {
            criteria.add((Criterion)Restrictions.eq((String)valueParameter.fieldName, (Object)valueParameter.getValue()));
        } else if (valueParameter.getOperator() == SearchOperator.LIKE) {
            criteria.add((Criterion)Restrictions.like((String)valueParameter.fieldName, (Object)valueParameter.getValue()));
        }
    }

    private static void handleSortType(Criteria criteria, SearchParameterBase parameter) {
        SortParameter sortParameter = (SortParameter)parameter;
        if (SortingOrder.DESCENDING == sortParameter.getSortingOrder()) {
            criteria.addOrder(Order.desc((String)sortParameter.fieldName));
        } else {
            criteria.addOrder(Order.asc((String)sortParameter.fieldName));
        }
    }

    private static void handleRangeType(Criteria criteria, SearchParameterBase parameter) {
        Object value;
        RangeParameter range = (RangeParameter)parameter;
        if (range.getFrom() != null) {
            value = range.getFrom();
            if (SearchType.DATE == range.getFieldType()) {
                value = CriteriaBuilder.toDate(value);
            }
            criteria.add((Criterion)Restrictions.ge((String)range.getFieldName(), (Object)value));
        }
        if (range.getTo() != null) {
            value = range.getTo();
            if (SearchType.DATE == range.getFieldType()) {
                value = CriteriaBuilder.toDate(value);
            }
            criteria.add((Criterion)Restrictions.le((String)range.getFieldName(), (Object)value));
        }
    }

    private static Object toDate(Object value) {
        return DateFormatter.toDate((String)("" + value), (String)"yyyy-MM-dd");
    }
}

