/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.google.common.collect.Iterables;
import com.tandbergtv.workflow.core.entity.SelectorKey;
import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateAttribute;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateDTO;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateTypeId;
import com.tandbergtv.workflow.core.util.HibernateTemplate;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import com.tandbergtv.workflow.core.util.SessionUtils;
import com.tandbergtv.workflow.driver.template.internal.FinderException;
import com.tandbergtv.workflow.driver.template.internal.TemplateNameUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class TemplateDAO {
    private static final Logger LOGGER = Logger.getLogger(TemplateDAO.class);
    private static final String VERSION_FIELD = "version";
    private static final String NAME_FIELD = "name";
    private static final String ID_FIELD = "id";
    private SessionFactory sessionFactory;

    public TemplateDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkflowTemplateDTO> loadActiveTemplates() {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String hsql = "SELECT wt FROM WorkflowTemplateDTO wt WHERE wt.typeId = ? order by wt.createDate, wt.name";
            Query query = session.createQuery(hsql);
            query.setParameter(0, (Object)WorkflowTemplateTypeId.ACTIVE);
            List list = query.list();
            return list;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    public void create(WorkflowTemplateDTO dto) {
        this.updateDTO(dto);
        try (Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);){
            session.beginTransaction();
            session.save((Object)dto);
            session.getTransaction().commit();
        }
    }

    private void updateDTO(WorkflowTemplateDTO dto) {
        WorkflowTemplateTypeId typeId = dto.getTypeId() == null ? WorkflowTemplateTypeId.ACTIVE : dto.getTypeId();
        TemplateContentTypeEnum contentType = dto.getContentType() == null ? TemplateContentTypeEnum.JPDL_XML : dto.getContentType();
        dto.setTypeId(typeId);
        dto.setContentType(contentType);
    }

    public void createTemplateWithSelectorKey(WorkflowTemplateDTO dto, List<String> selectorkeys) {
        this.updateDTO(dto);
        try (Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);){
            session.beginTransaction();
            session.save((Object)dto);
            for (String selectorKeyString : selectorkeys) {
                SelectorKey selectorKey = new SelectorKey(selectorKeyString, dto.getName());
                session.save((Object)selectorKey);
            }
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(WorkflowTemplateAttribute templateAttribute, long templateId) {
        String vars = JsonObjectMapper.toJsonString((Map)templateAttribute.getVariables());
        String timeouts = JsonObjectMapper.toJsonString((Map)templateAttribute.getNodeTimeouts());
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            session.beginTransaction();
            Query query = session.createQuery("update WorkflowTemplateDTO set variables = :vars,  nodeTimeouts = :nodeTimeouts where id = :id");
            query.setParameter("vars", (Object)vars);
            query.setParameter("nodeTimeouts", (Object)timeouts);
            query.setParameter(ID_FIELD, (Object)templateId);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String templateName, int version) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            Query query = session.createQuery("delete WorkflowTemplateDTO where name = :name and version = :version");
            query.setParameter(NAME_FIELD, (Object)templateName);
            query.setParameter(VERSION_FIELD, (Object)version);
            int n = query.executeUpdate();
            return n;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowTemplateDTO getTemplateById(long id) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)session.get(WorkflowTemplateDTO.class, (Serializable)Long.valueOf(id));
            return workflowTemplateDTO;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowTemplateDTO getActiveTemplateByFullName(String templateName) {
        Assert.notNull((Object)templateName, (String)"Template Name cannot be null");
        String[] values = TemplateNameUtil.splitFullName(templateName);
        int version = TemplateNameUtil.getVersion(templateName);
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String hsql = "SELECT wt FROM WorkflowTemplateDTO wt WHERE wt.typeId = 2 and wt.name = :name and wt.version = :version";
            Query query = session.createQuery(hsql);
            query.setParameter(NAME_FIELD, (Object)values[0]);
            query.setParameter(VERSION_FIELD, (Object)version);
            List results = query.list();
            WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)Iterables.getFirst((Iterable)results, null);
            return workflowTemplateDTO;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowTemplateDTO getTemplate(String name, int version) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String hsql = "SELECT wt FROM WorkflowTemplateDTO wt WHERE wt.name = :name and wt.version = :version ";
            Query query = session.createQuery(hsql);
            query.setParameter(NAME_FIELD, (Object)name);
            query.setParameter(VERSION_FIELD, (Object)version);
            List results = query.list();
            WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)Iterables.getFirst((Iterable)results, null);
            return workflowTemplateDTO;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowTemplateDTO getLatestTemplateByName(String templateName) {
        Assert.notNull((Object)templateName, (String)"Template Name cannot be null");
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String hsql = "SELECT wt FROM WorkflowTemplateDTO wt WHERE wt.typeId = 2 and wt.name = :name order by wt.version desc";
            Query query = session.createQuery(hsql);
            query.setParameter(NAME_FIELD, (Object)templateName);
            List results = query.list();
            WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)Iterables.getFirst((Iterable)results, null);
            return workflowTemplateDTO;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTemplateIdByVersion(String name, int version) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            Query query = session.createQuery("SELECT wt.id FROM WorkflowTemplateDTO wt WHERE wt.name = :name and wt.version = :version ");
            query.setParameter(NAME_FIELD, (Object)name);
            query.setParameter(VERSION_FIELD, (Object)version);
            List results = query.list();
            Long l = (Long)Iterables.getFirst((Iterable)results, null);
            return l;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectorKey(String selectionKey, String templateName) {
        try (Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);){
            SelectorKey selectorKey = new SelectorKey();
            selectorKey.setKey(selectionKey);
            selectorKey.setTemplateName(templateName);
            session.beginTransaction();
            session.save((Object)selectorKey);
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectorKey(String selectionKey, String templateName) {
        try (Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);){
            session.beginTransaction();
            SelectorKey selectorKey = new SelectorKey();
            selectorKey.setKey(selectionKey);
            selectorKey.setTemplateName(templateName);
            session.delete((Object)selectorKey);
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplateNameBySelectorKey(String selectionKey) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            Query query = session.createQuery("SELECT templateName FROM SelectorKey WHERE key = :key");
            query.setParameter("key", (Object)selectionKey);
            Object templateName = query.uniqueResult();
            String string = templateName == null ? null : (String)templateName;
            return string;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSelectorKeysByTemplateName(String templateName) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            Query query = session.createQuery("SELECT key FROM SelectorKey WHERE templateName = :name");
            query.setParameter(NAME_FIELD, (Object)templateName);
            List list = query.list();
            return list;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getPreviousVersionTemplateId(String name, int version) throws FinderException {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            Query query = session.createQuery("SELECT wt.id FROM WorkflowTemplateDTO wt WHERE wt.name = :name and wt.version < :version order by wt.version,wt.updateDate DESC");
            query.setParameter(NAME_FIELD, (Object)name);
            query.setParameter(VERSION_FIELD, (Object)version);
            List results = query.list();
            if (CollectionUtils.isEmpty((Collection)results)) {
                throw new FinderException("Previous inactive versions of the template: " + name + " doesn't exist.");
            }
            Long l = (Long)Iterables.getFirst((Iterable)results, null);
            return l;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedActiveVersion(String name, int version) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            Query query = session.createQuery("SELECT count(id) FROM WorkflowTemplateDTO wt WHERE    wt.typeId = 2 and wt.name = :name and wt.version = :version");
            query.setParameter(NAME_FIELD, (Object)name);
            query.setParameter(VERSION_FIELD, (Object)version);
            Long recordCount = (Long)query.uniqueResult();
            boolean bl = recordCount > 0L;
            return bl;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedVersion(String name, int version) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String hsql = "SELECT count(id) FROM WorkflowTemplateDTO wt WHERE wt.name = :name and wt.version = :version";
            Query query = session.createQuery(hsql);
            query.setParameter(NAME_FIELD, (Object)name);
            query.setParameter(VERSION_FIELD, (Object)version);
            Long recordCount = (Long)query.uniqueResult();
            boolean bl = recordCount > 0L;
            return bl;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedVersionInlegacyModel(String name, int version) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String sql = "SELECT count(id_) FROM jbpm_processdefinition wt WHERE wt.name_ = :name and wt.version_ = :version";
            SQLQuery query = session.createSQLQuery(sql);
            query.setParameter(NAME_FIELD, (Object)name);
            query.setParameter(VERSION_FIELD, (Object)version);
            int recordCount = HibernateTemplate.toInteger((Object)query.uniqueResult());
            boolean bl = recordCount > 0;
            return bl;
        }
        catch (Exception e) {
            LOGGER.info((Object)("Failed to check version in legacy mode" + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicatedVersion(String name, int version, long id) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String hsql = "SELECT count(id) FROM WorkflowTemplateDTO wt WHERE  wt.name = :name and wt.version = :version and wt.id != :id";
            Query query = session.createQuery(hsql);
            query.setParameter(NAME_FIELD, (Object)name);
            query.setParameter(VERSION_FIELD, (Object)version);
            query.setParameter(ID_FIELD, (Object)id);
            Long recordCount = (Long)query.uniqueResult();
            boolean bl = recordCount > 0L;
            return bl;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    public void activate(long templateId) {
        this.updateTemplateTypeId(templateId, WorkflowTemplateTypeId.ACTIVE);
    }

    public void deactivate(long templateId) {
        this.updateTemplateTypeId(templateId, WorkflowTemplateTypeId.INACTIVE);
    }

    public void pendingDelete(long templateId) {
        this.updateTemplateTypeId(templateId, WorkflowTemplateTypeId.PENDINGDELETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTemplateTypeId(long templateId, WorkflowTemplateTypeId typeId) {
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            session.beginTransaction();
            Query query = session.createQuery("update WorkflowTemplateDTO set typeId = :typeId where id = :id");
            query.setParameter("typeId", (Object)typeId);
            query.setParameter(ID_FIELD, (Object)templateId);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    public void update(WorkflowTemplateDTO dto) {
        try (Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);){
            session.beginTransaction();
            session.merge((Object)dto);
            session.getTransaction().commit();
        }
    }
}

