/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.spi.annotation.PrivateApi;
import java.nio.ByteBuffer;

@PrivateApi
public final class Packet
extends HeapData
implements OutboundFrame {
    public static final byte VERSION = 4;
    public static final int FLAG_OP = 1;
    public static final int FLAG_RESPONSE = 2;
    public static final int FLAG_EVENT = 4;
    public static final int FLAG_URGENT = 16;
    public static final int FLAG_BIND = 32;
    public static final int FLAG_OP_CONTROL = 64;
    private static final int HEADER_SIZE = 11;
    private short flags;
    private int partitionId;
    private transient Connection conn;
    private int valueOffset;
    private int size;
    private boolean headerComplete;

    public Packet() {
    }

    public Packet(byte[] payload) {
        this(payload, -1);
    }

    public Packet(byte[] payload, int partitionId) {
        super(payload);
        this.partitionId = partitionId;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public Packet setFlag(int flag) {
        this.flags = (short)(this.flags | flag);
        return this;
    }

    public Packet setAllFlags(int flags) {
        this.flags = (short)flags;
        return this;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    public short getFlags() {
        return this.flags;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void reset() {
        this.headerComplete = false;
    }

    @Override
    public boolean isUrgent() {
        return this.isFlagSet(16);
    }

    public boolean writeTo(ByteBuffer dst) {
        if (!this.headerComplete) {
            if (dst.remaining() < 11) {
                return false;
            }
            dst.put((byte)4);
            dst.putShort(this.flags);
            dst.putInt(this.partitionId);
            this.size = this.totalSize();
            dst.putInt(this.size);
            this.headerComplete = true;
        }
        return this.writeValue(dst);
    }

    public boolean readFrom(ByteBuffer src) {
        if (!this.headerComplete) {
            if (src.remaining() < 11) {
                return false;
            }
            byte version = src.get();
            if (4 != version) {
                throw new IllegalArgumentException("Packet versions are not matching! Expected -> 4, Incoming -> " + version);
            }
            this.flags = src.getShort();
            this.partitionId = src.getInt();
            this.size = src.getInt();
            this.headerComplete = true;
        }
        return this.readValue(src);
    }

    private boolean readValue(ByteBuffer src) {
        if (this.payload == null) {
            this.payload = new byte[this.size];
        }
        if (this.size > 0) {
            boolean done;
            int bytesRead;
            int bytesNeeded;
            int bytesReadable = src.remaining();
            if (bytesReadable >= (bytesNeeded = this.size - this.valueOffset)) {
                bytesRead = bytesNeeded;
                done = true;
            } else {
                bytesRead = bytesReadable;
                done = false;
            }
            src.get(this.payload, this.valueOffset, bytesRead);
            this.valueOffset += bytesRead;
            if (!done) {
                return false;
            }
        }
        return true;
    }

    private boolean writeValue(ByteBuffer dst) {
        if (this.size > 0) {
            boolean done;
            int bytesWrite;
            int bytesNeeded;
            int bytesWritable = dst.remaining();
            if (bytesWritable >= (bytesNeeded = this.size - this.valueOffset)) {
                bytesWrite = bytesNeeded;
                done = true;
            } else {
                bytesWrite = bytesWritable;
                done = false;
            }
            byte[] byteArray = this.toByteArray();
            dst.put(byteArray, this.valueOffset, bytesWrite);
            this.valueOffset += bytesWrite;
            if (!done) {
                return false;
            }
        }
        return true;
    }

    public int packetSize() {
        return (this.payload != null ? this.totalSize() : 0) + 11;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Packet)) {
            return false;
        }
        Packet packet = (Packet)o;
        if (!super.equals(packet)) {
            return false;
        }
        if (this.flags != packet.flags) {
            return false;
        }
        return this.partitionId == packet.partitionId;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.flags;
        result = 31 * result + this.partitionId;
        return result;
    }

    @Override
    public String toString() {
        return "Packet{flags=" + this.flags + ", isResponse=" + this.isFlagSet(2) + ", isOperation=" + this.isFlagSet(1) + ", isEvent=" + this.isFlagSet(4) + ", partitionId=" + this.partitionId + ", conn=" + this.conn + '}';
    }
}

