/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.http.servlet;

import com.ericsson.neptune.http.servlet.HttpServletUtil;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CacheControlFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CacheControlFilter.class);
    private static final int MILLI_IN_SEC = 1000;
    private static final long DAY_IN_MILLISEC = 86400000L;
    public static final long DEFAULT_ONE_YEAR_SECONDS = 31536000L;
    private static final String PARAM_EXPIRES_SECONDS = "expiresSeconds";
    private long expiresSeconds;

    public void init(FilterConfig filterConfig) throws ServletException {
        String expiresSecondsParam = filterConfig.getInitParameter(PARAM_EXPIRES_SECONDS);
        this.expiresSeconds = expiresSecondsParam != null ? Long.valueOf(expiresSecondsParam) : 31536000L;
        LOGGER.debug((Object)(CacheControlFilter.class.getName() + " is initialized."));
    }

    public void destroy() {
        LOGGER.debug((Object)(CacheControlFilter.class.getName() + " is destroyed."));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!HttpServletUtil.isHttpServlet(request, response)) {
            filterChain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if (requestURI.contains(".nocache.")) {
            this.setNoCacheControl(httpResponse);
        } else {
            this.setExpiresHeader(httpResponse);
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private void setNoCacheControl(HttpServletResponse httpResponse) {
        Date now = new Date();
        httpResponse.setDateHeader("Date", now.getTime());
        httpResponse.setDateHeader("Expires", now.getTime() - 86400000L);
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
    }

    private void setExpiresHeader(HttpServletResponse response) {
        response.setDateHeader("Expires", System.currentTimeMillis() + this.expiresSeconds * 1000L);
        response.setHeader("Cache-Control", "private, max-age=" + this.expiresSeconds);
    }
}

