/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.http.servlet;

import com.ericsson.neptune.http.servlet.GZipServletResponseWrapper;
import com.ericsson.neptune.http.servlet.HttpServletUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GZipFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(GZipFilter.class);
    private static final String ENCODING_GZIP = "gzip";

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug((Object)(GZipFilter.class.getName() + " is initialized."));
    }

    public void destroy() {
        LOGGER.debug((Object)(GZipFilter.class.getName() + " is destroyed."));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!HttpServletUtil.isHttpServlet(request, response)) {
            filterChain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.acceptsGZipEncoding(httpRequest)) {
            httpResponse.addHeader("Content-Encoding", ENCODING_GZIP);
            GZipServletResponseWrapper gzipResponse = new GZipServletResponseWrapper(httpResponse);
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)gzipResponse);
            gzipResponse.finish();
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private boolean acceptsGZipEncoding(HttpServletRequest httpRequest) {
        String acceptEncoding = httpRequest.getHeader("Accept-Encoding");
        return StringUtils.contains((String)acceptEncoding, (String)ENCODING_GZIP);
    }
}

