/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.SettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class BasicFileSystemValidator
implements SettingValidator {
    private static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");

    @Override
    public void setOtherSettingsValues(Map<String, String> otherSettingsValues) {
    }

    @Override
    public void setValidatorParameters(Map<String, String> validatorParameters) {
    }

    @Override
    public ValidationResult validate(SettingDefinition setting, String value) {
        String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
        ValidationResult result = new ValidationResult();
        ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
        String diplayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(setting.getPath(), setting.getDisplayName().get(0).getValue(), currentLocale);
        params.add(ServiceMessageBundleUtil.createLocalizedParam(diplayName));
        String needValidPathMessage = ServiceMessageBundleUtil.getAdminLocaleValue("needValidPath", defaultMessageBundle.getString("needValidPath"), currentLocale, diplayName);
        if (value == null || value.isEmpty()) {
            result.addMessage(needValidPathMessage, currentLocale, params);
            return result.fail();
        }
        File directory = new File(value);
        if (!directory.isDirectory()) {
            result.addMessage(needValidPathMessage, currentLocale, params);
            return result.fail();
        }
        if (!directory.canRead()) {
            result.addMessage("{0}: " + value + ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("directoryNotAccessible", defaultMessageBundle.getString("directoryNotAccessible"), currentLocale), currentLocale, params);
            return result.fail();
        }
        if (!directory.canWrite()) {
            result.addMessage("{0}: " + value + ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("directoryPermissionError", defaultMessageBundle.getString("directoryPermissionError"), currentLocale), currentLocale, params);
            return result.fail();
        }
        return result.success();
    }
}

