/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.ComplexSetting;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import com.tandbergtv.neptune.configuration.settings.validator.GroupValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComplexSettingValidator
implements GroupValidator {
    private static final String ARRAYS_REGEX = "(\\[\\d*\\])";
    private static final Pattern ARRAYS_PATTERN = Pattern.compile("(\\[\\d*\\])");
    private SettingGroup group;
    private Map<String, String> values;
    private static final String PATH_SEPARATOR = ".";
    private Set<String> settingsPaths = new TreeSet<String>();
    private Map<String, Integer> arrayLengths = new HashMap<String, Integer>();
    private static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");

    @Override
    public List<ValidationResult> validate(SettingGroup group, Map<String, String> values) {
        this.group = group;
        this.values = values;
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>();
        List<SettingDefinition> settings = group.getSettings();
        if (!settings.isEmpty() && settings.get(0) instanceof ComplexSetting) {
            this.buildSettingsTree("", group.getSettings().get(0));
            this.validateInvalidPaths(errors);
        }
        return errors;
    }

    private void validateArrayBounds(String settingPath, List<ValidationResult> errors) {
        String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
        Matcher m = ARRAYS_PATTERN.matcher(settingPath);
        while (m.find()) {
            String arrayName = settingPath.substring(0, m.start());
            String arrayLengthStr = settingPath.substring(m.start() + 1, m.end() - 1);
            int arrayLenght = Integer.parseInt(arrayLengthStr);
            String arrayPath = arrayName.replaceAll("\\[\\d*\\]", "");
            Integer maxLength = this.arrayLengths.get(arrayPath);
            if (maxLength == null) {
                maxLength = -1;
            }
            if (arrayLenght < maxLength) continue;
            ValidationResult result = new ValidationResult();
            ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(3);
            ArrayList<LocalizedString> settingToBeInserted = new ArrayList<LocalizedString>(1);
            settingToBeInserted.add(new LocalizedString(settingPath, currentLocale));
            params.add(settingToBeInserted);
            ArrayList<LocalizedString> settingInvalidArray = new ArrayList<LocalizedString>(1);
            settingInvalidArray.add(new LocalizedString(arrayName, currentLocale));
            params.add(settingInvalidArray);
            ArrayList<LocalizedString> arrayOverflow = new ArrayList<LocalizedString>(1);
            arrayOverflow.add(new LocalizedString(maxLength.toString(), currentLocale));
            params.add(arrayOverflow);
            String message = ServiceMessageBundleUtil.getAdminLocaleValue("arrayBoundsError", defaultMessageBundle.getString("arrayBoundsError"), currentLocale, settingPath, arrayName, maxLength.toString());
            result.fail().addMessage(message, currentLocale, params);
            errors.add(result);
        }
    }

    private void validateInvalidPaths(List<ValidationResult> errors) {
        String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
        for (String settingToBeSaved : this.values.keySet()) {
            Matcher m = ARRAYS_PATTERN.matcher(settingToBeSaved);
            String settingToBeSavedPath = m.replaceAll("");
            if (!this.settingsPaths.contains(settingToBeSavedPath)) {
                ValidationResult result = new ValidationResult();
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(3);
                ArrayList<LocalizedString> settingToBeInserted = new ArrayList<LocalizedString>(1);
                settingToBeInserted.add(new LocalizedString(settingToBeSaved, currentLocale));
                params.add(settingToBeInserted);
                ArrayList<LocalizedString> settingPath = new ArrayList<LocalizedString>(1);
                settingPath.add(new LocalizedString(settingToBeSavedPath, currentLocale));
                params.add(settingPath);
                String displayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(this.group.getPath(), this.group.getDisplayName().get(0).getValue(), currentLocale);
                params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
                String message = ServiceMessageBundleUtil.getAdminLocaleValue("invalidPaths", defaultMessageBundle.getString("invalidPaths"), currentLocale, settingToBeSaved, settingToBeSavedPath, displayName);
                result.fail().addMessage(message, currentLocale, params);
                errors.add(result);
                continue;
            }
            this.validateArrayBounds(settingToBeSaved, errors);
        }
    }

    protected void buildSettingsTree(String parent, SettingDefinition def) {
        String settingPath = def.getName();
        if (!parent.isEmpty()) {
            settingPath = parent + PATH_SEPARATOR + def.getName();
        }
        this.settingsPaths.add(settingPath);
        if (def instanceof ComplexSetting) {
            ComplexSetting setting = (ComplexSetting)def;
            if (setting.getMax() == null || setting.getMax() > 1) {
                if (setting.getMax() == null) {
                    this.arrayLengths.put(settingPath, Integer.MAX_VALUE);
                } else {
                    this.arrayLengths.put(settingPath, setting.getMax());
                }
            }
            for (SettingDefinition child : setting.getSettings()) {
                this.buildSettingsTree(settingPath, child);
            }
        }
    }
}

