/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import com.tandbergtv.neptune.i18n.service.bundle.DynamicMessageBundleImpl;
import com.tandbergtv.neptune.i18n.service.bundle.FileResourceBundle;
import com.tandbergtv.neptune.i18n.service.bundle.FileResourceBundleControl;
import com.tandbergtv.neptune.i18n.service.bundle.ResourceBundleFileNameHelper;
import com.tandbergtv.neptune.i18n.service.io.FileResourceWatcher;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class I18nResourceServiceDelegate
implements I18nResourceService {
    private String resoruceFolder = "";
    private String neptuneResourceFolder = "";
    private Logger logger = Logger.getLogger(I18nResourceServiceDelegate.class);
    private FileResourceWatcher folderWatcher;
    private volatile boolean started;

    public I18nResourceServiceDelegate(String confFolder, FileResourceWatcher folderWatcher) {
        this.resoruceFolder = confFolder;
        this.neptuneResourceFolder = this.resoruceFolder + File.separator + "neptunesettings";
        this.folderWatcher = folderWatcher;
    }

    public I18nResourceServiceDelegate() {
        this.resoruceFolder = "/opt/tandbergtv/cms/conf/i18n";
        this.neptuneResourceFolder = "/opt/tandbergtv/cms/conf/i18n/neptunesettings";
        this.folderWatcher = new FileResourceWatcher(Lists.newArrayList((Object[])new String[]{this.resoruceFolder, this.neptuneResourceFolder}));
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.loadBundlesByLocale(null);
        this.folderWatcher.start();
        this.started = true;
    }

    private List<ResourceBundle> loadBundlesByLocale(Locale locale) {
        if (locale == null) {
            return this.loadBundlesFromPaths(this.getAllBundlePaths());
        }
        return this.loadBundlesFromPaths(this.filterPathsByLocaleInFileName(locale));
    }

    private List<Path> filterPathsByLocaleInFileName(Locale locale) {
        ArrayList pathOfLocale = Lists.newArrayList();
        this.getAllBundlePaths().stream().filter(p -> {
            ResourceBundleFileNameHelper fileNameHelper = ResourceBundleFileNameHelper.parseFileName(p.getFileName().toString());
            return fileNameHelper.getLocale().equals(locale);
        }).forEach(pathOfLocale::add);
        return pathOfLocale;
    }

    private ArrayList<Path> getAllBundlePaths() {
        ArrayList filePaths = Lists.newArrayList();
        filePaths.addAll(this.getI18nResourcePaths());
        filePaths.addAll(this.getNeptuneSettingResourcePaths());
        return filePaths;
    }

    private List<Path> getI18nResourcePaths() {
        return this.folderWatcher.listFiles(Paths.get(this.resoruceFolder, new String[0]));
    }

    private List<Path> getNeptuneSettingResourcePaths() {
        return this.folderWatcher.listFiles(Paths.get(this.neptuneResourceFolder, new String[0]));
    }

    private List<ResourceBundle> loadBundlesFromPaths(List<Path> filePaths) {
        ArrayList bundles = Lists.newArrayList();
        for (Path path : filePaths) {
            ResourceBundle resourceBundle = FileResourceBundle.getBundleFromPath(path);
            if (resourceBundle == null) {
                this.logger.warn((Object)("Bundle file " + path.getFileName().toString() + " can't be loaded."));
                continue;
            }
            bundles.add(resourceBundle);
        }
        return bundles;
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.folderWatcher.stop();
        }
    }

    @Override
    public Map<String, String> getAvailableLanguageMap() {
        HashMap localeLanguageMap = Maps.newHashMap();
        FileResourceBundleControl.getInstance().getResourceBundleLocaleCache().values().forEach(locale -> {
            if (locale == Locale.ROOT) {
                return;
            }
            StringBuilder localeLanguageValueString = new StringBuilder();
            localeLanguageValueString.append(locale.getDisplayLanguage((Locale)locale));
            if (!locale.getCountry().isEmpty()) {
                localeLanguageValueString.append(" - " + locale.getDisplayCountry(Locale.ENGLISH));
            }
            localeLanguageMap.putIfAbsent(locale.toString(), localeLanguageValueString.toString());
        });
        return localeLanguageMap;
    }

    @Override
    public List<ResourceBundle> getAvilableBundles() {
        return this.loadBundlesByLocale(null);
    }

    @Override
    public List<ResourceBundle> getAvilableBundles(Locale locale) {
        return this.loadBundlesByLocale(locale);
    }

    @Override
    public MessageBundle getMessageBundleInstance() {
        return new DynamicMessageBundleImpl(this);
    }

    @Override
    public Set<String> getNeptuneSettingMappingBundleNames() {
        return FileResourceBundleControl.getInstance().getBundleNamesForNeptuneSettings();
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Set<Locale> getAvailableLocales() {
        return Sets.newHashSet(FileResourceBundleControl.getInstance().getResourceBundleLocaleCache().values());
    }
}

