/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.service.bundle;

import com.google.common.base.Strings;
import com.tandbergtv.neptune.i18n.service.bundle.FileResourceBundleControl;
import com.tandbergtv.neptune.i18n.service.bundle.ResourceBundleFileNameHelper;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class FileResourceBundle
extends PropertyResourceBundle {
    private static final String PACKAGE_SPERARATOR = ".";
    private static Logger logger = Logger.getLogger(FileResourceBundle.class);

    public FileResourceBundle(Reader reader) throws IOException {
        super(reader);
    }

    public static ResourceBundle getBundleFromPath(Path filePath) {
        return FileResourceBundle.getBundleFromPath(filePath, FileResourceBundleControl.getInstance());
    }

    public static ResourceBundle getBundleFromPath(Path filePath, FileResourceBundleControl control) {
        logger.debug((Object)("file name before remove extension" + filePath.getFileName().toString()));
        ResourceBundleFileNameHelper fileNameHelper = ResourceBundleFileNameHelper.parseFileName(filePath.getFileName().toString());
        if (fileNameHelper == null) {
            return null;
        }
        logger.debug((Object)("base name:" + fileNameHelper.getBaseName() + ", locale:" + fileNameHelper.getLocale()));
        return FileResourceBundle.getBundle(fileNameHelper.getBaseName(), fileNameHelper.getLocale(), control);
    }

    public static ResourceBundle getBundleByParameter(String baseName, Locale locale, ResourceBundle.Control resourceBundleControl) {
        ResourceBundle resourceBundle;
        if (Strings.isNullOrEmpty((String)baseName)) {
            throw new IllegalArgumentException("Bundle's base name shouldn't be null");
        }
        Locale tempLocale = Locale.ROOT;
        if (locale != null) {
            tempLocale = locale;
        }
        if (baseName.indexOf(PACKAGE_SPERARATOR) > -1) {
            String fileName = baseName.substring(baseName.indexOf(PACKAGE_SPERARATOR), baseName.length());
            resourceBundle = FileResourceBundle.getBundleFromPath(Paths.get(fileName, new String[0]));
            if (resourceBundle == null) {
                resourceBundle = FileResourceBundle.getBundle(baseName, tempLocale);
            }
        } else {
            resourceBundle = FileResourceBundle.getBundle(baseName, tempLocale, resourceBundleControl);
        }
        return resourceBundle;
    }

    public static ResourceBundle getBundleByParameter(String baseName, Locale locale) {
        return FileResourceBundle.getBundleByParameter(baseName, locale, FileResourceBundleControl.getInstance());
    }

    public static ResourceBundle getBundleByBundleName(String bundleName) {
        ResourceBundleFileNameHelper helper = ResourceBundleFileNameHelper.parseFileName(bundleName);
        return FileResourceBundle.getBundleByParameter(helper.getBaseName(), helper.getLocale(), FileResourceBundleControl.getInstance());
    }
}

