/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.service.bundle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tandbergtv.neptune.i18n.service.bundle.FileResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileResourceBundleControl
extends ResourceBundle.Control {
    private final String resourcePath;
    private Set<String> reloadBundleSet = Sets.newConcurrentHashSet();
    private static FileResourceBundleControl fileResourceBundleControl = new FileResourceBundleControl();
    private static Logger logger = Logger.getLogger(FileResourceBundleControl.class);
    private long bundleCacheTTL;
    private Map<String, Locale> resourceBundleLocaleCache = Maps.newConcurrentMap();
    private Set<String> bundleNamesForNeptuneSettings = Sets.newConcurrentHashSet();

    private FileResourceBundleControl() {
        this.resourcePath = "/opt/tandbergtv/cms/conf/i18n";
        this.bundleCacheTTL = 30000L;
    }

    public FileResourceBundleControl(String resourcePath, long bundleCacheTTL) {
        this.resourcePath = resourcePath;
        this.bundleCacheTTL = bundleCacheTTL;
    }

    public static FileResourceBundleControl getInstance() {
        return fileResourceBundleControl;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        logger.debug((Object)("bundle name:" + bundleName + ".properties"));
        FileResourceBundle fileResourceBundle = null;
        if (!this.bundleNamesForNeptuneSettings.contains(bundleName)) {
            fileResourceBundle = this.loadBundleFromConfFolder(bundleName);
        }
        if (fileResourceBundle == null) {
            fileResourceBundle = this.loadBundleFromNeptuneSettingFolder(bundleName);
            this.updateNeptuneSettingBundleNames(fileResourceBundle, bundleName);
        }
        if (this.reloadBundleSet.contains(bundleName)) {
            logger.debug((Object)("bundle name:" + bundleName + " removed from reload list"));
            this.reloadBundleSet.remove(bundleName);
        }
        if (fileResourceBundle == null) {
            this.removeFromLocaleCache(bundleName);
            logger.debug((Object)("resource bundle " + bundleName + " couldn't be found under i18n and its children folder."));
            return null;
        }
        this.addToLocaleCache(bundleName, locale);
        logger.info((Object)("Loaded bundle :" + bundleName));
        return fileResourceBundle;
    }

    private void updateNeptuneSettingBundleNames(FileResourceBundle fileResourceBundle, String bundleName) {
        if (fileResourceBundle == null) {
            logger.debug((Object)("Removing bundle name for neptunesettings:" + bundleName));
            this.bundleNamesForNeptuneSettings.remove(bundleName);
        } else {
            logger.debug((Object)("Adding bundle name for neptunesettings:" + bundleName));
            this.bundleNamesForNeptuneSettings.add(bundleName);
        }
    }

    private FileResourceBundle loadBundleFromNeptuneSettingFolder(String bundleName) throws IOException {
        String neptuneSettingFileURI = this.resourcePath + File.separator + "neptunesettings" + File.separator + bundleName + ".properties";
        logger.debug((Object)("Loading bundle from path:" + neptuneSettingFileURI));
        FileResourceBundle fileResourceBundle = this.newBundleFromPath(neptuneSettingFileURI);
        return fileResourceBundle;
    }

    private FileResourceBundle loadBundleFromConfFolder(String bundleName) throws IOException {
        String regularFileURI = this.resourcePath + File.separator + bundleName + ".properties";
        logger.debug((Object)("Loading bundle from path:" + regularFileURI));
        FileResourceBundle fileResourceBundle = this.newBundleFromPath(regularFileURI);
        return fileResourceBundle;
    }

    private void addToLocaleCache(String bundleName, Locale locale) {
        if (locale != null) {
            this.resourceBundleLocaleCache.putIfAbsent(bundleName, locale);
        }
    }

    private void removeFromLocaleCache(String bundleName) {
        if (this.resourceBundleLocaleCache.containsKey(bundleName)) {
            this.resourceBundleLocaleCache.remove(bundleName);
            logger.debug((Object)("removed locale in cache for bundle " + bundleName));
        }
    }

    private FileResourceBundle newBundleFromPath(String fileURI) throws IOException {
        FileResourceBundle fileResourceMessageBundle = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(fileURI)));){
            logger.debug((Object)("find file from path:" + fileURI));
            fileResourceMessageBundle = new FileResourceBundle(reader);
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)e);
        }
        return fileResourceMessageBundle;
    }

    public void reloadBundleAtNextVisit(String baseName, Locale locale) {
        this.reloadBundleSet.add(this.toBundleName(baseName, locale));
        logger.debug((Object)("Added  bundle " + baseName + "_" + locale.toString() + " for reload"));
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        if (this.reloadBundleSet.contains(this.toBundleName(baseName, locale))) {
            logger.debug((Object)("bundle " + baseName + "_" + locale.toString() + " needs to reload"));
            return true;
        }
        return false;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return this.bundleCacheTTL;
    }

    @Override
    public List<Locale> getCandidateLocales(String baseName, Locale locale) {
        return Lists.newArrayList((Object[])new Locale[]{locale});
    }

    public Map<String, Locale> getResourceBundleLocaleCache() {
        return Collections.unmodifiableMap(this.resourceBundleLocaleCache);
    }

    public Set<String> getBundleNamesForNeptuneSettings() {
        return Collections.unmodifiableSet(this.bundleNamesForNeptuneSettings);
    }

    @Override
    public String toBundleName(String baseName, Locale locale) {
        return baseName + (locale == null || locale == Locale.ROOT ? "" : "_" + locale.toString());
    }
}

