/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import org.apache.log4j.Logger;

public abstract class AbstractMetadataParserHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(AbstractMetadataParserHandler.class);

    public AbstractMetadataParserHandler() {
    }

    public AbstractMetadataParserHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage msg) throws HandlerException {
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage process(IMessage request) throws HandlerException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage requestMsg = null;
        WorkflowMessage responseMsg = null;
        try {
            Thread.currentThread().setContextClassLoader(AbstractMetadataParserHandler.class.getClassLoader());
            requestMsg = converter.convert(request);
            responseMsg = this.performOperation(requestMsg);
        }
        catch (Exception e) {
            String errorMessage = "Failed to perform operation, error: " + e.getMessage();
            responseMsg = this.generateNackMessage(requestMsg, errorMessage);
            logger.error((Object)errorMessage, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        try {
            return converter.convert(responseMsg);
        }
        catch (Exception e) {
            throw new HandlerException("Fail to convert from WorkflowMessage to IMessage", (Throwable)e);
        }
    }

    protected WorkflowMessage generateNackMessage(WorkflowMessage request, String errorMessage) {
        WorkflowMessage response = WorkflowMessageFactory.createNackMessage((WorkflowMessage)request);
        response.putValue("error-message", errorMessage);
        return response;
    }

    protected abstract WorkflowMessage performOperation(WorkflowMessage var1) throws Exception;
}

